/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.managers;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CrTIngredientUtil;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import org.apache.logging.log4j.Logger;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersiveengineering/Blueprint")
@ZenCodeType.Name(value="mods.immersiveengineering.Blueprint")
public class BlueprintCraftingRecipeManager
implements IRecipeManager<BlueprintCraftingRecipe> {
    public RecipeType<BlueprintCraftingRecipe> getRecipeType() {
        return BlueprintCraftingRecipe.TYPE;
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, final String blueprintCategory, IIngredientWithAmount[] inputs, IItemStack output) {
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", recipePath);
        IngredientWithSize[] ingredients = CrTIngredientUtil.getIngredientsWithSize(inputs);
        ItemStack results = output.getInternal();
        BlueprintCraftingRecipe recipe = new BlueprintCraftingRecipe(resourceLocation, blueprintCategory, IESerializableRecipe.of(results), ingredients);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe<BlueprintCraftingRecipe>((IRecipeManager)this, recipe, null){

            public boolean validate(Logger logger) {
                if (!BlueprintCraftingRecipe.recipeCategories.contains(blueprintCategory)) {
                    logger.error("Blueprint Category '{}' does not exist!", (Object)blueprintCategory);
                    return false;
                }
                return true;
            }
        });
    }
}

