/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.common.items.SawbladeItem;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class GrindingDiskItem
extends SawbladeItem {
    private static final Set<Material> materials = ImmutableSet.of((Object)Material.f_76279_, (Object)Material.f_76281_);
    private static final Set<ToolAction> TOOL_ACTIONS = ImmutableSet.of((Object)ToolActions.PICKAXE_DIG, (Object)ToolActions.AXE_STRIP, (Object)ToolActions.AXE_SCRAPE, (Object)ToolActions.AXE_WAX_OFF, (Object)Lib.WIRECUTTER_DIG);
    private static final ListTag ENCHANTS = new ListTag();
    public static final ResourceLocation TEXTURE = ImmersiveEngineering.rl("item/grindingdisk_blade");

    public GrindingDiskItem(int maxDamage, float sawbladeSpeed, float sawbladeDamage) {
        super(maxDamage, sawbladeSpeed, sawbladeDamage, TEXTURE);
    }

    @Override
    public int getSawbladeDamageFromBlock(boolean effective) {
        return effective ? 1 : 10;
    }

    @Override
    public boolean canSawbladeFellTree() {
        return false;
    }

    @Override
    public ListTag getSawbladeEnchants() {
        return ENCHANTS.m_6426_();
    }

    @Override
    public Predicate<BlockState> getSawbladeMaterials() {
        return s -> materials.contains(s.m_60767_()) || s.m_204336_(IETags.wirecutterHarvestable);
    }

    @Override
    public Set<ToolAction> getToolActions() {
        return TOOL_ACTIONS;
    }

    static {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", "silk_touch");
        tag.m_128405_("lvl", 1);
        ENCHANTS.add((Object)tag);
    }
}

