/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import blusunrize.immersiveengineering.client.models.obj.callback.DynamicSubmodelCallbacks;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.blocks.metal.TurretBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TurretGunBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TurretRenderer
extends IEBlockEntityRenderer<TurretBlockEntity<?>> {
    public static final Map<IEBlocks.BlockEntry<?>, String> MODEL_NAME_BY_BLOCK = ImmutableMap.of(IEBlocks.MetalDevices.TURRET_CHEM, (Object)"turret_chem", IEBlocks.MetalDevices.TURRET_GUN, (Object)"turret_gun");
    public static final Map<IEBlocks.BlockEntry<?>, String> MODEL_FILE_BY_BLOCK = ImmutableMap.of(IEBlocks.MetalDevices.TURRET_CHEM, (Object)"block/metal_device/chem_turret.obj.ie", IEBlocks.MetalDevices.TURRET_GUN, (Object)"block/metal_device/gun_turret.obj.ie");
    private static final Map<ResourceLocation, DynamicModel> MODELS_BY_BLOCK = new HashMap<ResourceLocation, DynamicModel>();

    public void render(TurretBlockEntity<?> tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.getLevelNonnull().m_46805_(tile.m_58899_())) {
            return;
        }
        BlockState state = tile.m_58900_();
        if (state.m_60734_() != IEBlocks.MetalDevices.TURRET_CHEM.get() && state.m_60734_() != IEBlocks.MetalDevices.TURRET_GUN.get()) {
            return;
        }
        BakedModel model = MODELS_BY_BLOCK.get(state.m_60734_().getRegistryName()).get();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        float defaultYaw = 180.0f - tile.getFacing().m_122435_();
        matrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), tile.rotationYaw + defaultYaw, true));
        matrixStack.m_85845_(new Quaternion(new Vector3f(-1.0f, 0.0f, 0.0f), tile.rotationPitch, true));
        TurretRenderer.renderModelPart(bufferIn, matrixStack, tile.getLevelNonnull(), state, model, tile.m_58899_(), true, combinedLightIn, "gun");
        if (tile instanceof TurretGunBlockEntity) {
            TurretGunBlockEntity gunTurret = (TurretGunBlockEntity)tile;
            if (gunTurret.cycleRender > 0) {
                float cycle = 0.0f;
                cycle = gunTurret.cycleRender > 3 ? (float)(5 - gunTurret.cycleRender) / 2.0f : (float)gunTurret.cycleRender / 3.0f;
                matrixStack.m_85837_(0.0, 0.0, (double)cycle * 0.3125);
            }
            TurretRenderer.renderModelPart(bufferIn, matrixStack, tile.getLevelNonnull(), state, model, tile.m_58899_(), false, combinedLightIn, "action");
        }
        matrixStack.m_85849_();
    }

    public static void renderModelPart(MultiBufferSource buffer, PoseStack matrix, Level world, BlockState state, BakedModel model, BlockPos pos, boolean isFirst, int light, String ... parts) {
        pos = pos.m_7494_();
        TransformingVertexBuilder solidBuilder = new TransformingVertexBuilder(buffer, RenderType.m_110451_(), matrix);
        matrix.m_85836_();
        matrix.m_85837_(-0.5, 0.0, -0.5);
        List quads = model.getQuads(state, null, Utils.RAND, new SinglePropertyModelData<IEProperties.VisibilityList>(IEProperties.VisibilityList.show(parts), DynamicSubmodelCallbacks.getProperty()));
        RenderUtils.renderModelTESRFancy(quads, solidBuilder, world, pos, !isFirst, -1, light);
        matrix.m_85849_();
    }

    public static void fillModels() {
        MODEL_NAME_BY_BLOCK.forEach((key, value) -> MODELS_BY_BLOCK.put(key.getId(), new DynamicModel((String)value)));
    }
}

