/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.BERenderUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.common.blocks.metal.SawmillBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class SawmillRenderer
extends IEBlockEntityRenderer<SawmillBlockEntity> {
    public static final String NAME = "sawmill_blade";
    public static DynamicModel BLADE;

    public void render(SawmillBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        boolean sawblade;
        if (!te.formed || te.isDummy() || !te.getLevelNonnull().m_46805_(te.m_58899_())) {
            return;
        }
        BlockPos blockPos = te.m_58899_();
        BlockState state = te.m_58904_().m_8055_(blockPos);
        if (state.m_60734_() != IEBlocks.Multiblocks.SAWMILL.get()) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.0, 0.5);
        bufferIn = BERenderUtils.mirror(te, matrixStack, bufferIn);
        VertexConsumer solidBuilder = bufferIn.m_6299_(RenderType.m_110451_());
        Direction facing = te.getFacing();
        float dir = facing == Direction.SOUTH ? 180.0f : (facing == Direction.NORTH ? 0.0f : (facing == Direction.EAST ? -90.0f : 90.0f));
        matrixStack.m_85845_(new Quaternion(0.0f, dir, 0.0f, true));
        boolean bl = sawblade = !te.sawblade.m_41619_();
        if (sawblade) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(1.0, 0.125, -0.5);
            float spin = te.animation_bladeRotation;
            if (te.shouldRenderAsActive()) {
                spin += 36.0f * partialTicks;
            }
            matrixStack.m_85845_(new Quaternion(0.0f, 0.0f, spin, true));
            RenderUtils.renderModelTESRFast(BLADE.getNullQuads(), solidBuilder, matrixStack, combinedLightIn, combinedOverlayIn);
            matrixStack.m_85849_();
        }
        for (SawmillBlockEntity.SawmillProcess process : te.sawmillProcessQueue) {
            float relative = process.getRelativeProcessStep(te.m_58904_());
            ItemStack rendered = process.getCurrentStack(te.m_58904_(), sawblade);
            this.renderItem(rendered, relative, matrixStack, bufferIn, combinedLightIn, combinedOverlayIn);
        }
        matrixStack.m_85849_();
    }

    private void renderItem(ItemStack stack, float progress, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float xOffset = -2.5f + progress * 5.0f;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)xOffset, 0.375, 0.0);
        matrixStack.m_85845_(new Quaternion(0.0f, 0.0f, 90.0f, true));
        ClientUtils.mc().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, 0);
        matrixStack.m_85849_();
    }
}

