/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.fx;

import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.mixin.accessors.client.ParticleManagerAccess;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;

public class CustomParticleManager {
    private final List<Particle> particles = new ArrayList<Particle>();

    public void clientTick() {
        Iterator<Particle> iterator = this.particles.iterator();
        while (iterator.hasNext()) {
            Particle p = iterator.next();
            p.m_5989_();
            if (p.m_107276_()) continue;
            iterator.remove();
        }
    }

    public <T extends ParticleOptions> void add(T particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int maxAge) {
        Particle newParticle = ((ParticleManagerAccess)Minecraft.m_91087_().f_91061_).invokeMakeParticle(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        if (newParticle == null) {
            return;
        }
        if (maxAge > 0) {
            newParticle.m_107257_(maxAge);
        }
        this.particles.add(newParticle);
    }

    public void render(PoseStack matrixStack, MultiBufferSource bufferIn, float partialTicks) {
        if (this.particles.isEmpty()) {
            return;
        }
        matrixStack.m_85836_();
        Camera activeInfo = Minecraft.m_91087_().f_91063_.m_109153_();
        matrixStack.m_85837_(activeInfo.m_90583_().f_82479_, activeInfo.m_90583_().f_82480_, activeInfo.m_90583_().f_82481_);
        VertexConsumer baseBuffer = IERenderTypes.whiteLightmap(bufferIn).m_6299_(IERenderTypes.PARTICLES);
        TransformingVertexBuilder particleBuilder = new TransformingVertexBuilder(baseBuffer, matrixStack, DefaultVertexFormat.f_85813_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        particleBuilder.setNormal(0.0f, 1.0f, 0.0f);
        particleBuilder.setOverlay(OverlayTexture.f_118083_);
        for (Particle p : this.particles) {
            p.m_5744_((VertexConsumer)particleBuilder, activeInfo, partialTicks);
        }
        matrixStack.m_85849_();
    }
}

