/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.placementhandlers;

import com.google.common.collect.ImmutableList;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JigsawPlacementHandler
implements IPlacementHandler {
    public boolean canHandle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        return blockState.m_60734_() instanceof JigsawBlock;
    }

    public IPlacementHandler.ActionProcessingResult handle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, PlacementSettings settings) {
        if (complete) {
            WorldUtil.setBlockState((LevelAccessor)world, pos, blockState, 3);
            if (tileEntityData != null) {
                try {
                    PlacementHandlers.handleTileEntityPlacement((CompoundTag)tileEntityData, (Level)world, (BlockPos)pos, (PlacementSettings)settings);
                    blockState.m_60734_().m_6402_(world, pos, blockState, null, BlockUtils.getItemStackFromBlockState((BlockState)blockState));
                }
                catch (Exception ex) {
                    Log.getLogger().warn("Unable to place TileEntity");
                }
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }
        if (tileEntityData != null && tileEntityData.m_128441_("final_state")) {
            String stateString = tileEntityData.m_128461_("final_state");
            BlockStateParser blockstateparser = new BlockStateParser(new StringReader(stateString), false);
            BlockState finalState = Blocks.f_50016_.m_49966_();
            try {
                blockstateparser.m_116806_(true);
                BlockState resultState = blockstateparser.m_116808_();
                if (resultState != null) {
                    finalState = resultState;
                }
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                Log.getLogger().warn("Unable to place Jigsaw");
            }
            WorldUtil.setBlockState((LevelAccessor)world, pos, finalState, 3);
        }
        return IPlacementHandler.ActionProcessingResult.SUCCESS;
    }

    public List<ItemStack> getRequiredItems(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
        if (complete) {
            return ImmutableList.of((Object)new ItemStack((ItemLike)Blocks.f_50678_));
        }
        String stateString = tileEntityData.m_128461_("final_state");
        BlockStateParser blockstateparser = new BlockStateParser(new StringReader(stateString), false);
        BlockState finalState = Blocks.f_50016_.m_49966_();
        try {
            blockstateparser.m_116806_(true);
            BlockState resultState = blockstateparser.m_116808_();
            if (resultState != null) {
                finalState = resultState;
            }
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            Log.getLogger().warn("Unable to place Jigsaw");
        }
        if (finalState.m_60734_() == Blocks.f_50016_) {
            return Collections.emptyList();
        }
        return ImmutableList.of((Object)BlockUtils.getItemStackFromBlockState((BlockState)finalState));
    }
}

