/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.permissions;

import com.ldtteam.structurize.items.ItemScanTool;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.Explosions;
import com.minecolonies.api.colony.permissions.PermissionEvent;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.blocks.BlockDecorationController;
import com.minecolonies.coremod.blocks.huts.BlockHutTownHall;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyPermissionEventHandler {
    private final Colony colony;
    private Map<UUID, Long> lastPlayerNotificationTick = new HashMap<UUID, Long>();

    public ColonyPermissionEventHandler(Colony colony) {
        this.colony = colony;
    }

    @SubscribeEvent
    public void on(BlockEvent.EntityPlaceEvent event) {
        Action action;
        Action action2 = action = event.getPlacedBlock().m_60734_() instanceof AbstractBlockHut ? Action.PLACE_HUTS : Action.PLACE_BLOCKS;
        if (((Boolean)MineColonies.getConfig().getServer().enableColonyProtection.get()).booleanValue() && this.checkBlockEventDenied(event.getWorld(), event.getPos(), event.getEntity(), event.getPlacedBlock(), action)) {
            this.cancelEvent((Event)event, event.getEntity(), this.colony, action, event.getPos());
        }
    }

    private boolean checkBlockEventDenied(LevelAccessor worldIn, BlockPos posIn, Entity entity, BlockState blockState, Action action) {
        if (entity instanceof Player) {
            @NotNull Player player = EntityUtils.getPlayerOfFakePlayer((Player)entity, entity.f_19853_);
            if (this.colony.isCoordInColony(entity.f_19853_, posIn)) {
                if (blockState.m_60734_() instanceof AbstractBlockHut && this.colony.getPermissions().hasPermission(player, action)) {
                    return false;
                }
                return !this.colony.getPermissions().hasPermission(player, action);
            }
        }
        return false;
    }

    private void cancelEvent(Event event, @Nullable Entity entity, Colony colony, Action action, BlockPos pos) {
        event.setResult(Event.Result.DENY);
        if (event.isCancelable()) {
            event.setCanceled(true);
            if (entity == null) {
                if (colony.hasTownHall()) {
                    colony.getBuildingManager().getTownHall().addPermissionEvent(new PermissionEvent(null, "-", action, pos));
                }
                return;
            }
            if (colony.hasTownHall()) {
                colony.getBuildingManager().getTownHall().addPermissionEvent(new PermissionEvent(entity.m_142081_(), entity.m_7755_().getString(), action, pos));
            }
            if (entity instanceof FakePlayer) {
                return;
            }
            long worldTime = entity.f_19853_.m_46467_();
            if (!this.lastPlayerNotificationTick.containsKey(entity.m_142081_()) || this.lastPlayerNotificationTick.get(entity.m_142081_()) + (long)(20 * (Integer)MineColonies.getConfig().getServer().secondsBetweenPermissionMessages.get()) < worldTime) {
                MessageUtils.format("com.minecolonies.coremod.permission.no", new Object[0]).sendTo((Player)entity);
                this.lastPlayerNotificationTick.put(entity.m_142081_(), worldTime);
            }
        }
    }

    @SubscribeEvent
    public void on(BlockEvent.BreakEvent event) {
        LevelAccessor world = event.getWorld();
        if (!((Boolean)MineColonies.getConfig().getServer().enableColonyProtection.get()).booleanValue() || world.m_5776_()) {
            return;
        }
        if (event.getState().m_60734_() instanceof AbstractBlockHut) {
            @Nullable IBuilding building = IColonyManager.getInstance().getBuilding(event.getPlayer().f_19853_, event.getPos());
            if (building == null) {
                return;
            }
            if (event.getState().m_60734_() == ModBlocks.blockHutTownHall && !((BlockHutTownHall)event.getState().m_60734_()).getValidBreak() && !event.getPlayer().m_7500_()) {
                this.cancelEvent((Event)event, (Entity)event.getPlayer(), this.colony, Action.BREAK_HUTS, event.getPos());
                return;
            }
            if (!building.getColony().getPermissions().hasPermission(event.getPlayer(), Action.BREAK_HUTS) && this.checkEventCancelation(Action.BREAK_HUTS, event.getPlayer(), event.getPlayer().m_20193_(), (Event)event, event.getPos())) {
                return;
            }
            building.destroy();
            if (((Boolean)MineColonies.getConfig().getServer().pvp_mode.get()).booleanValue() && event.getState().m_60734_() == ModBlocks.blockHutTownHall) {
                IColonyManager.getInstance().deleteColonyByWorld(building.getColony().getID(), false, event.getPlayer().f_19853_);
            }
        } else if (event.getState().m_60734_() instanceof BlockDecorationController) {
            this.colony.getBuildingManager().removeLeisureSite(event.getPos());
        } else {
            this.checkEventCancelation(Action.BREAK_BLOCKS, event.getPlayer(), event.getPlayer().m_20193_(), (Event)event, event.getPos());
        }
    }

    @SubscribeEvent
    public void on(ExplosionEvent.Detonate event) {
        if (MineColonies.getConfig().getServer().turnOffExplosionsInColonies.get() == Explosions.DAMAGE_EVERYTHING) {
            return;
        }
        Level eventWorld = event.getWorld();
        Predicate<BlockPos> getBlocksInColony = pos -> this.colony.isCoordInColony(eventWorld, (BlockPos)pos);
        Predicate<Entity> getEntitiesInColony = entity -> (!(entity instanceof Enemy) || entity instanceof Llama) && this.colony.isCoordInColony(entity.m_20193_(), new BlockPos(entity.m_20182_()));
        switch ((Explosions)((Object)MineColonies.getConfig().getServer().turnOffExplosionsInColonies.get())) {
            case DAMAGE_NOTHING: {
                getEntitiesInColony = entity -> this.colony.isCoordInColony(entity.m_20193_(), new BlockPos(entity.m_20182_()));
            }
            case DAMAGE_PLAYERS: {
                List entitiesToRemove = event.getAffectedEntities().stream().filter(getEntitiesInColony).filter(entity -> !(entity instanceof ServerPlayer)).collect(Collectors.toList());
                event.getAffectedEntities().removeAll(entitiesToRemove);
            }
            case DAMAGE_ENTITIES: {
                List blocksToRemove = event.getAffectedBlocks().stream().filter(getBlocksInColony).collect(Collectors.toList());
                event.getAffectedBlocks().removeAll(blocksToRemove);
                break;
            }
        }
    }

    @SubscribeEvent
    public void on(ExplosionEvent.Start event) {
        if (((Boolean)MineColonies.getConfig().getServer().enableColonyProtection.get()).booleanValue() && MineColonies.getConfig().getServer().turnOffExplosionsInColonies.get() == Explosions.DAMAGE_NOTHING && this.colony.isCoordInColony(event.getWorld(), new BlockPos(event.getExplosion().getPosition()))) {
            this.cancelEvent((Event)event, null, this.colony, Action.EXPLODE, new BlockPos(event.getExplosion().getPosition()));
        }
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent event) {
        if (this.colony.isCoordInColony(event.getWorld(), event.getPos()) && !(event instanceof PlayerInteractEvent.EntityInteract) && !(event instanceof PlayerInteractEvent.EntityInteractSpecific)) {
            Block block = event.getWorld().m_8055_(event.getPos()).m_60734_();
            if (event instanceof PlayerInteractEvent.RightClickBlock && block instanceof AbstractBlockHut && !this.colony.getPermissions().hasPermission(event.getPlayer(), Action.ACCESS_HUTS)) {
                this.cancelEvent((Event)event, (Entity)event.getPlayer(), this.colony, Action.ACCESS_HUTS, event.getPos());
                return;
            }
            Permissions perms = this.colony.getPermissions();
            if (this.isFreeToInteractWith(block, event.getPos()) && perms.hasPermission(event.getPlayer(), Action.ACCESS_FREE_BLOCKS)) {
                return;
            }
            if (((Boolean)MineColonies.getConfig().getServer().enableColonyProtection.get()).booleanValue()) {
                if (!perms.hasPermission(event.getPlayer(), Action.RIGHTCLICK_BLOCK) && !(block instanceof AirBlock)) {
                    this.checkEventCancelation(Action.RIGHTCLICK_BLOCK, event.getPlayer(), event.getWorld(), (Event)event, event.getPos());
                    return;
                }
                if (block instanceof BaseEntityBlock && !perms.hasPermission(event.getPlayer(), Action.OPEN_CONTAINER)) {
                    this.cancelEvent((Event)event, (Entity)event.getPlayer(), this.colony, Action.OPEN_CONTAINER, event.getPos());
                    return;
                }
                if (event.getWorld().m_7702_(event.getPos()) != null && !perms.hasPermission(event.getPlayer(), Action.RIGHTCLICK_ENTITY)) {
                    this.checkEventCancelation(Action.RIGHTCLICK_ENTITY, event.getPlayer(), event.getWorld(), (Event)event, event.getPos());
                    return;
                }
                ItemStack stack = event.getItemStack();
                if (ItemStackUtils.isEmpty(stack).booleanValue() || stack.m_41614_()) {
                    return;
                }
                if (stack.m_41720_() instanceof PotionItem) {
                    this.checkEventCancelation(Action.THROW_POTION, event.getPlayer(), event.getWorld(), (Event)event, event.getPos());
                    return;
                }
                if (stack.m_41720_() instanceof ItemScanTool && !perms.hasPermission(event.getPlayer(), Action.USE_SCAN_TOOL)) {
                    this.cancelEvent((Event)event, (Entity)event.getPlayer(), this.colony, Action.USE_SCAN_TOOL, event.getPos());
                }
            }
        }
    }

    private boolean isFreeToInteractWith(@Nullable Block block, BlockPos pos) {
        return block != null && (IColonyManager.getInstance().getCompatibilityManager().isFreeBlock(block) || this.colony.getFreeBlocks().contains(block) || block.m_49966_().m_204336_(ModTags.colonyProtectionException)) || this.colony.getFreePositions().contains(pos) || IColonyManager.getInstance().getCompatibilityManager().isFreePos(pos);
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent.EntityInteract event) {
        if (this.isFreeToInteractWith(null, event.getPos()) && this.colony.getPermissions().hasPermission(event.getPlayer(), Action.ACCESS_FREE_BLOCKS)) {
            return;
        }
        this.checkEventCancelation(Action.RIGHTCLICK_ENTITY, event.getPlayer(), event.getWorld(), (Event)event, event.getPos());
    }

    private boolean checkEventCancelation(Action action, @NotNull Player playerIn, @NotNull Level world, @NotNull Event event, @Nullable BlockPos pos) {
        @NotNull Player player = EntityUtils.getPlayerOfFakePlayer(playerIn, world);
        BlockPos positionToCheck = pos;
        if (null == positionToCheck) {
            positionToCheck = new BlockPos(player.m_20182_());
        }
        if (((Boolean)MineColonies.getConfig().getServer().enableColonyProtection.get()).booleanValue() && this.colony.isCoordInColony(player.m_20193_(), positionToCheck) && !this.colony.getPermissions().hasPermission(player, action)) {
            if (((Boolean)MineColonies.getConfig().getServer().pvp_mode.get()).booleanValue() && !world.f_46443_ && this.colony.isValidAttackingPlayer(playerIn)) {
                return false;
            }
            this.cancelEvent(event, (Entity)player, this.colony, action, positionToCheck);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent.EntityInteractSpecific event) {
        if (this.isFreeToInteractWith(null, event.getPos()) && this.colony.getPermissions().hasPermission(event.getPlayer(), Action.ACCESS_FREE_BLOCKS)) {
            return;
        }
        this.checkEventCancelation(Action.RIGHTCLICK_ENTITY, event.getPlayer(), event.getWorld(), (Event)event, event.getPos());
    }

    @SubscribeEvent
    public void on(ItemTossEvent event) {
        if (this.checkEventCancelation(Action.TOSS_ITEM, event.getPlayer(), event.getPlayer().m_20193_(), (Event)event, new BlockPos(event.getPlayer().m_20182_()))) {
            event.getPlayer().m_150109_().m_36054_(event.getEntityItem().m_32055_());
        }
    }

    @SubscribeEvent
    public void on(EntityItemPickupEvent event) {
        this.checkEventCancelation(Action.PICKUP_ITEM, event.getPlayer(), event.getPlayer().m_20193_(), (Event)event, new BlockPos(event.getPlayer().m_20182_()));
    }

    @SubscribeEvent
    public void on(FillBucketEvent event) {
        @Nullable BlockPos targetBlockPos = null;
        if (event.getTarget() instanceof BlockHitResult) {
            targetBlockPos = ((BlockHitResult)event.getTarget()).m_82425_();
        } else if (event.getTarget() instanceof EntityHitResult) {
            targetBlockPos = new BlockPos(((EntityHitResult)event.getTarget()).m_82443_().m_20182_());
        }
        this.checkEventCancelation(Action.FILL_BUCKET, event.getPlayer(), event.getPlayer().m_20193_(), (Event)event, targetBlockPos);
    }

    @SubscribeEvent
    public void on(ArrowLooseEvent event) {
        this.checkEventCancelation(Action.SHOOT_ARROW, event.getPlayer(), event.getPlayer().m_20193_(), (Event)event, new BlockPos(event.getPlayer().m_20182_()));
    }

    @SubscribeEvent
    public void on(LivingHurtEvent event) {
        if (event.getEntity() instanceof ServerPlayer && event.getSource() instanceof EntityDamageSource && event.getSource().m_7639_() instanceof EntityCitizen && ((EntityCitizen)event.getSource().m_7639_()).getCitizenColonyHandler().getColonyId() == this.colony.getID() && this.colony.getRaiderManager().isRaided() && !this.colony.getPermissions().hasPermission((Player)event.getEntity(), Action.GUARDS_ATTACK)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void on(AttackEntityEvent event) {
        if (event.getTarget() instanceof Monster) {
            return;
        }
        @NotNull Player player = EntityUtils.getPlayerOfFakePlayer(event.getPlayer(), event.getPlayer().m_20193_());
        if (((Boolean)MineColonies.getConfig().getServer().enableColonyProtection.get()).booleanValue() && this.colony.isCoordInColony(player.m_20193_(), new BlockPos(player.m_20182_()))) {
            Permissions perms = this.colony.getPermissions();
            if (event.getTarget() instanceof EntityCitizen) {
                AbstractEntityCitizen citizen = (AbstractEntityCitizen)event.getTarget();
                if (citizen.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && perms.hasPermission(event.getPlayer(), Action.GUARDS_ATTACK)) {
                    return;
                }
                if (perms.hasPermission(event.getPlayer(), Action.ATTACK_CITIZEN)) {
                    return;
                }
                this.cancelEvent((Event)event, (Entity)event.getPlayer(), this.colony, Action.ATTACK_CITIZEN, new BlockPos(event.getTarget().m_20182_()));
                return;
            }
            if (!(event.getTarget() instanceof Mob) && !perms.hasPermission(event.getPlayer(), Action.ATTACK_ENTITY)) {
                this.cancelEvent((Event)event, (Entity)event.getPlayer(), this.colony, Action.ATTACK_ENTITY, new BlockPos(event.getTarget().m_20182_()));
            }
        }
    }
}

