/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.Stash;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class ChangeDeliveryPriorityMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private boolean up;

    public ChangeDeliveryPriorityMessage() {
    }

    public ChangeDeliveryPriorityMessage(@NotNull IBuildingView building, boolean up) {
        super(building);
        this.up = up;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.up = buf.readBoolean();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeBoolean(this.up);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        if (building != null && building.hasModule(WorkerBuildingModule.class) || building instanceof Stash) {
            if (this.up) {
                building.alterPickUpPriority(1);
            } else {
                building.alterPickUpPriority(-1);
            }
            building.markDirty();
        }
    }
}

