/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.EntityListModule;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class AssignFilterableEntityMessage
extends AbstractBuildingServerMessage<AbstractBuilding> {
    private boolean assign;
    private ResourceLocation entity;
    private String id;

    public AssignFilterableEntityMessage() {
    }

    public AssignFilterableEntityMessage(IBuildingView building, String id, ResourceLocation entity, boolean assign) {
        super(building);
        this.assign = assign;
        this.entity = entity;
        this.id = id;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.assign = buf.readBoolean();
        this.entity = buf.m_130281_();
        this.id = buf.m_130136_(Short.MAX_VALUE);
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeBoolean(this.assign);
        buf.m_130085_(this.entity);
        buf.m_130070_(this.id);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, AbstractBuilding building) {
        if (building.hasModule(EntityListModule.class)) {
            if (this.assign) {
                building.getModuleMatching(EntityListModule.class, m -> m.getId().equals(this.id)).addEntity(this.entity);
            } else {
                building.getModuleMatching(EntityListModule.class, m -> m.getId().equals(this.id)).removeEntity(this.entity);
            }
        }
    }
}

