/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.tileentities.TileEntityGrave;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.coremod.network.messages.server.AbstractColonyServerMessage;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInventoryMessage
extends AbstractColonyServerMessage {
    private String name;
    private InventoryType inventoryType;
    private int entityID;
    private BlockPos tePos;

    public OpenInventoryMessage() {
    }

    public OpenInventoryMessage(IColonyView colony, @NotNull String name, int id) {
        super(colony);
        this.inventoryType = InventoryType.INVENTORY_CITIZEN;
        this.name = name;
        this.entityID = id;
    }

    public OpenInventoryMessage(IBuildingView building) {
        super(building.getColony());
        this.inventoryType = InventoryType.INVENTORY_CHEST;
        this.name = "";
        this.tePos = building.getID();
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.inventoryType = InventoryType.values()[buf.readInt()];
        this.name = buf.m_130136_(Short.MAX_VALUE);
        switch (this.inventoryType) {
            case INVENTORY_CITIZEN: {
                this.entityID = buf.readInt();
                break;
            }
            case INVENTORY_CHEST: 
            case INVENTORY_FIELD: {
                this.tePos = buf.m_130135_();
            }
        }
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.inventoryType.ordinal());
        buf.m_130070_(this.name);
        switch (this.inventoryType) {
            case INVENTORY_CITIZEN: {
                buf.writeInt(this.entityID);
                break;
            }
            case INVENTORY_CHEST: 
            case INVENTORY_FIELD: {
                buf.m_130064_(this.tePos);
            }
        }
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        ServerPlayer player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        switch (this.inventoryType) {
            case INVENTORY_CITIZEN: {
                this.doCitizenInventory(player);
                break;
            }
            case INVENTORY_CHEST: {
                this.doHutInventory(player, colony);
                break;
            }
            case INVENTORY_FIELD: {
                this.doFieldInventory(player);
                break;
            }
        }
    }

    private void doCitizenInventory(ServerPlayer player) {
        @Nullable AbstractEntityCitizen citizen = (AbstractEntityCitizen)CompatibilityUtils.getWorldFromEntity((Entity)player).m_6815_(this.entityID);
        if (citizen != null) {
            if (!StringUtil.m_14408_((String)this.name)) {
                citizen.getInventoryCitizen().setCustomName(this.name);
            }
            NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)citizen, packetBuffer -> packetBuffer.m_130130_(citizen.getCitizenColonyHandler().getColonyId()).m_130130_(citizen.getCivilianID()));
        }
    }

    private void doHutInventory(ServerPlayer player, IColony colony) {
        BlockEntity tileEntity = BlockPosUtil.getTileEntity(player.f_19853_, this.tePos);
        if (tileEntity instanceof TileEntityRack || tileEntity instanceof TileEntityGrave) {
            NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)((MenuProvider)tileEntity), packetBuffer -> packetBuffer.m_130130_(colony.getID()).m_130064_(tileEntity.m_58899_()));
        }
    }

    private void doFieldInventory(ServerPlayer player) {
        @NotNull ScarecrowTileEntity scarecrowTileEntity = (ScarecrowTileEntity)BlockPosUtil.getTileEntity(CompatibilityUtils.getWorldFromEntity((Entity)player), this.tePos);
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)scarecrowTileEntity);
    }

    private static enum InventoryType {
        INVENTORY_CITIZEN,
        INVENTORY_CHEST,
        INVENTORY_FIELD;

    }
}

