/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server;

import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.placement.StructurePlacementUtils;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IRSComponent;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.CreativeBuildingStructureHandler;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuilding;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.event.EventHandler;
import com.minecolonies.coremod.util.BuildingUtils;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildToolPasteMessage
implements IMessage {
    private BlockState state;
    private boolean complete;
    private String structureName;
    private String workOrderName;
    private int rotation;
    private BlockPos pos;
    private boolean isHut;
    private boolean mirror;

    public BuildToolPasteMessage() {
    }

    public BuildToolPasteMessage(String structureName, String workOrderName, BlockPos pos, int rotation, boolean isHut, Mirror mirror, boolean complete, BlockState state) {
        this.structureName = structureName;
        this.workOrderName = workOrderName;
        this.pos = pos;
        this.rotation = rotation;
        this.isHut = isHut;
        this.mirror = mirror == Mirror.FRONT_BACK;
        this.complete = complete;
        this.state = state;
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.structureName = buf.m_130136_(Short.MAX_VALUE);
        this.workOrderName = buf.m_130136_(Short.MAX_VALUE);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.rotation = buf.readInt();
        this.isHut = buf.readBoolean();
        this.mirror = buf.readBoolean();
        this.complete = buf.readBoolean();
        this.state = Block.m_49803_((int)buf.readInt());
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.m_130070_(this.structureName);
        buf.m_130070_(this.workOrderName);
        buf.writeInt(this.pos.m_123341_());
        buf.writeInt(this.pos.m_123342_());
        buf.writeInt(this.pos.m_123343_());
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.isHut);
        buf.writeBoolean(this.mirror);
        buf.writeBoolean(this.complete);
        buf.writeInt(Block.m_49956_((BlockState)this.state));
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        StructureName sn = new StructureName(this.structureName);
        ServerPlayer player = ctxIn.getSender();
        if (!Structures.hasMD5((StructureName)sn)) {
            MessageUtils.format((Component)new TextComponent("Can not build " + this.workOrderName + ": schematic missing!")).sendTo(new Player[]{player});
            return;
        }
        if (player.m_7500_()) {
            if (this.isHut) {
                BuildToolPasteMessage.handleHut(CompatibilityUtils.getWorldFromEntity((Entity)player), (Player)player, sn, this.rotation, this.pos, this.mirror, this.state, this.complete);
                CreativeBuildingStructureHandler.loadAndPlaceStructureWithRotation(player.f_19853_, this.structureName, this.pos, BlockPosUtil.getRotationFromRotations(this.rotation), this.mirror ? Mirror.FRONT_BACK : Mirror.NONE, !this.complete, player);
                @Nullable IBuilding building = IColonyManager.getInstance().getBuilding(CompatibilityUtils.getWorldFromEntity((Entity)player), this.pos);
                if (building != null) {
                    WorkOrderBuilding workOrder = WorkOrderBuilding.create(WorkOrderType.BUILD, building);
                    ConstructionTapeHelper.removeConstructionTape(workOrder, CompatibilityUtils.getWorldFromEntity((Entity)player));
                }
            } else {
                StructurePlacementUtils.loadAndPlaceStructureWithRotation((Level)ctxIn.getSender().f_19853_, (String)this.structureName, (BlockPos)this.pos, (Rotation)BlockPosUtil.getRotationFromRotations(this.rotation), (Mirror)(this.mirror ? Mirror.FRONT_BACK : Mirror.NONE), (!this.complete ? 1 : 0) != 0, (ServerPlayer)ctxIn.getSender());
            }
        } else if (this.structureName.contains("supply")) {
            int slot;
            if (player.m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)ModItems.supplyChest)) > 0 && !((Boolean)MineColonies.getConfig().getServer().allowInfiniteSupplyChests.get()).booleanValue() && !this.isFreeInstantPlacementMH(player)) {
                MessageUtils.format("com.minecolonies.coremod.error.supplychestalreadyplaced", new Object[0]).sendTo(new Player[]{player});
                return;
            }
            Predicate<ItemStack> searchPredicate = stack -> !stack.m_41619_();
            if (this.structureName.contains("supplyship")) {
                searchPredicate = searchPredicate.and(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, new ItemStack((ItemLike)ModItems.supplyChest), true, false));
            }
            if (this.structureName.contains("supplycamp")) {
                searchPredicate = searchPredicate.and(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, new ItemStack((ItemLike)ModItems.supplyCamp), true, false));
            }
            if (this.isFreeInstantPlacementMH(player)) {
                searchPredicate = searchPredicate.and(stack -> stack.m_41782_() && stack.m_41783_().m_128423_(Constants.PLACEMENT_NBT) != null && stack.m_41783_().m_128461_(Constants.PLACEMENT_NBT).equals(Constants.INSTANT_PLACEMENT));
            }
            if ((slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)new InvWrapper((Container)player.m_150109_()), searchPredicate)) != -1 && !ItemStackUtils.isEmpty(player.m_150109_().m_8016_(slot)).booleanValue()) {
                if (player.m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)ModItems.supplyChest)) < 1) {
                    MessageUtils.format("com.minecolonies.coremod.progress.supplies_placed", new Object[0]).sendTo(new Player[]{player});
                    player.m_6278_(Stats.f_12982_.m_12902_((Object)ModItems.supplyChest), 1);
                    AdvancementTriggers.PLACE_SUPPLY.trigger(player);
                }
                CreativeBuildingStructureHandler.loadAndPlaceStructureWithRotation(player.f_19853_, this.structureName, this.pos, BlockPosUtil.getRotationFromRotations(this.rotation), this.mirror ? Mirror.FRONT_BACK : Mirror.NONE, !this.complete, player);
            } else {
                MessageUtils.format("item.supplychestdeployer.missing", new Object[0]).sendTo(new Player[]{player});
            }
        }
    }

    private boolean isFreeInstantPlacementMH(ServerPlayer playerEntity) {
        ItemStack mhItem = playerEntity.m_21205_();
        return ItemStackUtils.isEmpty(mhItem) == false && mhItem.m_41783_() != null && mhItem.m_41783_().m_128461_(Constants.PLACEMENT_NBT).equals(Constants.INSTANT_PLACEMENT);
    }

    private static void handleHut(@NotNull Level world, @NotNull Player player, StructureName sn, int rotation, @NotNull BlockPos buildPos, boolean mirror, BlockState state, boolean complete) {
        Block block;
        IColony tempColony = IColonyManager.getInstance().getClosestColony(world, buildPos);
        if (!complete && tempColony != null && !tempColony.getPermissions().hasPermission(player, Action.MANAGE_HUTS) && IColonyManager.getInstance().isFarEnoughFromColonies(world, buildPos)) {
            return;
        }
        String hut = sn.getSection();
        ItemStack stack = BuildingUtils.getItemStackForHutFromInventory(player.m_150109_(), hut);
        Block block2 = block = stack.m_41720_() instanceof BlockItem ? ((BlockItem)stack.m_41720_()).m_40614_() : null;
        if (block != null && EventHandler.onBlockHutPlaced(world, player, block, buildPos)) {
            world.m_46961_(buildPos, true);
            world.m_46597_(buildPos, state);
            if (!complete) {
                ((AbstractBlockHut)block).onBlockPlacedByBuildTool(world, buildPos, world.m_8055_(buildPos), (LivingEntity)player, null, mirror, sn.getStyle());
                BuildToolPasteMessage.setupBuilding(world, player, sn, rotation, buildPos, mirror);
            }
        }
    }

    private static void setupBuilding(@NotNull Level world, @NotNull Player player, StructureName sn, int rotation, @NotNull BlockPos buildPos, boolean mirror) {
        @Nullable IBuilding building = IColonyManager.getInstance().getBuilding(world, buildPos);
        if (building == null) {
            Log.getLogger().error("BuildTool: building is null!", (Throwable)new Exception());
        } else {
            if (building.getTileEntity() != null) {
                IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, buildPos);
                if (colony == null) {
                    Log.getLogger().info("No colony for " + player.m_7755_().getString());
                } else {
                    building.getTileEntity().setColony(colony);
                }
            }
            building.setStyle(sn.getStyle());
            if (!(building instanceof IRSComponent)) {
                ConstructionTapeHelper.removeConstructionTape(building.getCorners(), world);
            }
            building.setIsMirrored(mirror);
        }
    }
}

