/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.items.AbstractItemScroll;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ItemScrollHighlight
extends AbstractItemScroll {
    public ItemScrollHighlight(Item.Properties properties) {
        super("scroll_highlight", properties);
    }

    @Override
    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        if (ctx.m_43725_().f_46443_ || ctx.m_43723_() == null || !ctx.m_43723_().m_6144_()) {
            return InteractionResult.PASS;
        }
        BlockEntity te = ctx.m_43725_().m_7702_(ctx.m_8083_());
        if (te instanceof TileEntityColonyBuilding) {
            ctx.m_43722_().m_41774_(1);
            if (ctx.m_43725_().f_46441_.nextInt(10) == 0) {
                ctx.m_43723_().m_5661_((Component)new TranslatableComponent("minecolonies.scroll.failed" + (ctx.m_43725_().f_46441_.nextInt(10) + 1)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
                ctx.m_43723_().m_7292_(new MobEffectInstance(MobEffects.f_19619_, 6000));
                SoundUtils.playSoundForPlayer((ServerPlayer)ctx.m_43723_(), SoundEvents.f_11889_, 0.3f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            TileEntityColonyBuilding building = (TileEntityColonyBuilding)te;
            Set<ICitizenData> citizens = building.getColony().getBuildingManager().getBuilding(ctx.m_8083_()).getAllAssignedCitizen();
            for (ICitizenData citizenData : citizens) {
                if (!citizenData.getEntity().isPresent()) continue;
                citizenData.getEntity().get().m_7292_(new MobEffectInstance(MobEffects.f_19619_, 2400));
                citizenData.getEntity().get().m_7292_(new MobEffectInstance(MobEffects.f_19596_, 2400));
            }
            SoundUtils.playSoundForPlayer((ServerPlayer)ctx.m_43723_(), SoundEvents.f_12275_, 0.3f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected boolean needsColony() {
        return false;
    }

    @Override
    protected ItemStack onItemUseSuccess(ItemStack itemStack, Level world, ServerPlayer player) {
        return itemStack;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        TranslatableComponent guiHint = new TranslatableComponent("item.minecolonies.scroll_highlight.tip");
        guiHint.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN));
        tooltip.add((Component)guiHint);
    }
}

