/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemScepterGuard
extends AbstractItemMinecolonies {
    private static final String TAG_LAST_POS = "lastPos";

    public ItemScepterGuard(Item.Properties properties) {
        super("scepterguard", properties.m_41487_(1).m_41503_(2));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockPos lastPos;
        CompoundTag compound;
        if (ctx.m_43725_().f_46443_) {
            return InteractionResult.FAIL;
        }
        ItemStack scepter = ctx.m_43723_().m_21120_(ctx.m_43724_());
        if (!scepter.m_41782_()) {
            scepter.m_41751_(new CompoundTag());
        }
        if ((compound = scepter.m_41783_()).m_128431_().contains(TAG_LAST_POS) && (lastPos = BlockPosUtil.read(compound, TAG_LAST_POS)).equals((Object)ctx.m_8083_())) {
            ctx.m_43723_().m_150109_().m_8016_(ctx.m_43723_().m_150109_().f_35977_);
            MessageUtils.format("com.minecolonies.coremod.job.guard.tooldoubleclick", new Object[0]).sendTo(ctx.m_43723_());
            return InteractionResult.FAIL;
        }
        return ItemScepterGuard.handleItemUsage(ctx.m_43725_(), ctx.m_8083_(), compound, ctx.m_43723_());
    }

    @NotNull
    private static InteractionResult handleItemUsage(Level worldIn, BlockPos pos, CompoundTag compound, Player playerIn) {
        if (!compound.m_128431_().contains("id")) {
            return InteractionResult.FAIL;
        }
        IColony colony = IColonyManager.getInstance().getColonyByWorld(compound.m_128451_("id"), worldIn);
        if (colony == null) {
            return InteractionResult.FAIL;
        }
        BlockPos guardTower = BlockPosUtil.read(compound, "pos");
        IBuilding hut = colony.getBuildingManager().getBuilding(guardTower);
        if (!(hut instanceof AbstractBuildingGuards)) {
            return InteractionResult.FAIL;
        }
        IGuardBuilding tower = (IGuardBuilding)hut;
        if (BlockPosUtil.getDistance2D(pos, guardTower) > (long)tower.getPatrolDistance()) {
            MessageUtils.format("com.minecolonies.coremod.job.guard.toolclickguardtoofar", new Object[0]).sendTo(playerIn);
            return InteractionResult.FAIL;
        }
        if (hut.getSetting(AbstractBuildingGuards.GUARD_TASK).getValue().equals("com.minecolonies.core.guard.setting.guard")) {
            MessageUtils.format("com.minecolonies.coremod.job.guard.toolclickguard", pos).sendTo(playerIn);
            tower.setGuardPos(pos);
            playerIn.m_150109_().m_8016_(playerIn.m_150109_().f_35977_);
        } else {
            if (!compound.m_128431_().contains(TAG_LAST_POS)) {
                tower.resetPatrolTargets();
            }
            tower.addPatrolTargets(pos);
            MessageUtils.format("com.minecolonies.coremod.job.guard.toolclickpatrol", pos).sendTo(playerIn);
        }
        BlockPosUtil.write(compound, TAG_LAST_POS, pos);
        return InteractionResult.SUCCESS;
    }
}

