/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenChatHandler;
import com.minecolonies.api.util.MessageUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.damagesource.DamageSource;

public class CitizenChatHandler
implements ICitizenChatHandler {
    private final AbstractEntityCitizen citizen;

    public CitizenChatHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public void notifyDeath(DamageSource damageSource) {
        if (this.citizen.getCitizenColonyHandler().getColony() != null && this.citizen.getCitizenData() != null) {
            IJob<?> job = this.citizen.getCitizenJobHandler().getColonyJob();
            TranslatableComponent contentComponent = job != null ? new TranslatableComponent("block.blockhuttownhall.messageworkerdead", new Object[]{new TranslatableComponent(job.getJobRegistryEntry().getTranslationKey()), this.citizen.getCitizenData().getName(), Math.round(this.citizen.m_20185_()), Math.round(this.citizen.m_20186_()), Math.round(this.citizen.m_20189_()), new TranslatableComponent(damageSource.f_19326_)}) : new TranslatableComponent("block.blockhuttownhall.messagecolonistdead", new Object[]{this.citizen.getCitizenData().getName(), Math.round(this.citizen.m_20185_()), Math.round(this.citizen.m_20186_()), Math.round(this.citizen.m_20189_()), new TranslatableComponent(damageSource.f_19326_)});
            MessageUtils.format((Component)contentComponent).with(ChatFormatting.RED).sendTo(this.citizen.getCitizenColonyHandler().getColony()).forManagers();
        }
    }

    @Override
    public void sendLocalizedChat(String keyIn, Object ... msg) {
        this.sendLocalizedChat((Component)new TranslatableComponent(keyIn, msg));
    }

    @Override
    public void sendLocalizedChat(Component component) {
        if (this.citizen.getCitizenColonyHandler().getColony() != null) {
            IJob<?> job = this.citizen.getCitizenJobHandler().getColonyJob();
            MessageUtils.MessageBuilder builder = job != null ? MessageUtils.format(job.getJobRegistryEntry().getTranslationKey(), new Object[0]).append((Component)new TextComponent(" ")).append(this.citizen.m_7770_()).append((Component)new TextComponent(": ")).append(component) : MessageUtils.format(this.citizen.m_7770_()).append((Component)new TextComponent(": ")).append(component);
            builder.sendTo(this.citizen.getCitizenColonyHandler().getColony()).forAllPlayers();
        }
    }
}

