/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.jobs.JobRanger;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.ai.citizen.guard.RangerCombatAI;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.entity.pathfinding.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobWalkRandomEdge;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIRanger
extends AbstractEntityAIGuard<JobRanger, AbstractBuildingGuards> {
    public static final String RENDER_META_ARROW = "arrow";

    public EntityAIRanger(@NotNull JobRanger job) {
        super(job);
        this.toolsNeeded.add(ToolType.BOW);
        new RangerCombatAI((EntityCitizen)this.worker, this.getStateAI(), this);
    }

    @Override
    protected void updateRenderMetaData() {
        Object renderMeta;
        Object object = renderMeta = this.getState() == AIWorkerState.IDLE ? "" : "working";
        if (this.worker.getCitizenInventoryHandler().hasItemInInventory(Items.f_42412_)) {
            renderMeta = (String)renderMeta + RENDER_META_ARROW;
        }
        this.worker.setRenderMetadata((String)renderMeta);
    }

    @Override
    protected void atBuildingActions() {
        super.atBuildingActions();
        if (this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARCHER_USE_ARROWS) > 0.0) {
            InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler(this.building, item -> item.m_41720_() instanceof ArrowItem, 64, (IItemHandler)this.worker.getInventoryCitizen());
            if (InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), item -> item.m_41720_() instanceof ArrowItem) < 16) {
                this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)Items.f_42412_), 64, 16);
            }
        }
    }

    @Override
    public void guardMovement() {
        if (this.worker.m_21187_().nextInt(3) < 1) {
            this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getGuardPos(), 3);
            return;
        }
        if (this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getGuardPos(), 10) || Math.abs(this.buildingGuards.getGuardPos().m_123342_() - this.worker.m_142538_().m_123342_()) > 3) {
            ((MinecoloniesAdvancedPathNavigate)this.worker.getNavigation()).setPathJob(new PathJobWalkRandomEdge(this.world, this.buildingGuards.getGuardPos(), 20, (LivingEntity)this.worker), null, 1.0, true);
        }
    }
}

