/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.lwjgl.BufferUtils;

public class RenderHelper {
    public static void renderBlock(PoseStack matrixStack, BlockState block, float x, float y, float z, float pitch, float yaw, float scale) {
        Minecraft mc = Minecraft.m_91087_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, (double)z);
        matrixStack.m_85841_(-scale, -scale, -scale);
        matrixStack.m_85837_(-0.5, -0.5, 0.0);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
        matrixStack.m_85837_(0.5, 0.0, -0.5);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(yaw));
        matrixStack.m_85837_(-0.5, 0.0, 0.5);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, -1.0);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
        mc.m_91289_().renderSingleBlock(block, matrixStack, (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
        buffers.m_109911_();
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }

    public static void renderEntity(PoseStack poseStack, int x, int y, double scale, float headYaw, float yaw, float pitch, LivingEntity livingEntity) {
        Minecraft mc = Minecraft.m_91087_();
        if (livingEntity.f_19853_ == null) {
            livingEntity.f_19853_ = mc.f_91073_;
        }
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 1050.0);
        poseStack.m_85841_(1.0f, 1.0f, -1.0f);
        poseStack.m_85837_(0.0, 0.0, 1000.0);
        poseStack.m_85841_((float)scale, (float)scale, (float)scale);
        Quaternion pitchRotation = Vector3f.f_122223_.m_122240_(pitch);
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        poseStack.m_85845_(pitchRotation);
        float oldYawOffset = livingEntity.f_20883_;
        float oldYaw = livingEntity.m_146908_();
        float oldPitch = livingEntity.m_146909_();
        float oldPrevYawHead = livingEntity.f_20886_;
        float oldYawHead = livingEntity.f_20885_;
        livingEntity.f_20883_ = 180.0f + yaw;
        livingEntity.m_146922_(180.0f + headYaw);
        livingEntity.m_146926_(-pitch);
        livingEntity.f_20885_ = livingEntity.m_146908_();
        livingEntity.f_20886_ = livingEntity.m_146908_();
        EntityRenderDispatcher dispatcher = mc.m_91290_();
        pitchRotation.m_80157_();
        dispatcher.m_114412_(pitchRotation);
        dispatcher.m_114468_(false);
        MultiBufferSource.BufferSource buffers = mc.m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> dispatcher.m_114384_((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)buffers, 0xF000F0));
        buffers.m_109911_();
        dispatcher.m_114468_(true);
        livingEntity.f_20883_ = oldYawOffset;
        livingEntity.m_146922_(oldYaw);
        livingEntity.m_146926_(oldPitch);
        livingEntity.f_20886_ = oldPrevYawHead;
        livingEntity.f_20885_ = oldYawHead;
        poseStack.m_85849_();
    }

    public static void scissor(PoseStack poseStack, int x, int y, int w, int h) {
        double scale = Minecraft.m_91087_().m_91268_().m_85449_();
        double[] xyzTranslation = RenderHelper.getGLTranslation(poseStack, scale);
        x = (int)((double)x * scale);
        y = (int)((double)y * scale);
        w = (int)((double)w * scale);
        h = (int)((double)h * scale);
        int scissorX = Math.round(Math.round(xyzTranslation[0] + (double)x));
        int scissorY = Math.round(Math.round((double)(Minecraft.m_91087_().m_91268_().m_85444_() - y - h) - xyzTranslation[1]));
        int scissorW = Math.round(w);
        int scissorH = Math.round(h);
        RenderSystem.m_69488_((int)scissorX, (int)scissorY, (int)scissorW, (int)scissorH);
    }

    public static void stopScissor() {
        RenderSystem.m_69471_();
    }

    private static double[] getGLTranslation(PoseStack poseStack, double scale) {
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        matrix.m_27650_(buf);
        return new double[]{(double)buf.get(RenderHelper.getIndexFloatBuffer(0, 3)) * scale, (double)buf.get(RenderHelper.getIndexFloatBuffer(1, 3)) * scale, (double)buf.get(RenderHelper.getIndexFloatBuffer(2, 3)) * scale};
    }

    private static int getIndexFloatBuffer(int x, int y) {
        return y * 4 + x;
    }
}

