/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.generalcommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.IColonyManagerCapability;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCOPCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelResource;

public class CommandPruneWorld
implements IMCOPCommand {
    private static final String RADIUS_ARG = "additional block protection radius";
    private static final String COMMAND_STAGE = "stage";
    private static final String REGION_FOLDER = "region";

    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        return this.tryPrune(context, 0);
    }

    private int executeWithPage(CommandContext<CommandSourceStack> context) {
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        return this.tryPrune(context, IntegerArgumentType.getInteger(context, (String)COMMAND_STAGE));
    }

    private int tryPrune(CommandContext<CommandSourceStack> context, int arg) {
        if (arg < 3) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.prune.next", new Object[]{arg + 1}), true);
            return 0;
        }
        int radius = IntegerArgumentType.getInteger(context, (String)RADIUS_ARG);
        int deleteCount = 0;
        ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
        File saveDir = new File(DimensionType.m_196975_((ResourceKey)world.m_46472_(), (Path)world.m_142572_().m_129843_(LevelResource.f_78182_)).toFile(), REGION_FOLDER);
        ArrayList<IColony> colonies = new ArrayList();
        IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null).orElseGet(null);
        if (cap == null) {
            return 0;
        }
        colonies = cap.getColonies();
        for (File currentRegion : saveDir.listFiles()) {
            int regionZ;
            int regionX;
            String[] split;
            if (currentRegion == null || !currentRegion.getName().contains(".mca") || (split = currentRegion.getName().split("\\.")).length != 4 || !this.isFarEnoughFromColonies(regionX = Integer.parseInt(split[1]), regionZ = Integer.parseInt(split[2]), radius, colonies)) continue;
            if (!currentRegion.delete()) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Could not delete file:" + currentRegion.getPath()), true);
                continue;
            }
            ++deleteCount;
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Deleted file:" + currentRegion.getPath()), true);
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Successfully deleted " + deleteCount + " regions!"), true);
        return 0;
    }

    private boolean isFarEnoughFromColonies(int regionX, int regionZ, int blockRadius, List<IColony> colonies) {
        for (IColony colony : colonies) {
            for (BlockPos buildingPos : colony.getBuildingManager().getBuildings().keySet()) {
                int maxX = buildingPos.m_123341_() + blockRadius >> 9;
                int minX = buildingPos.m_123341_() - blockRadius >> 9;
                int maxZ = buildingPos.m_123343_() + blockRadius >> 9;
                int minZ = buildingPos.m_123343_() - blockRadius >> 9;
                if (regionX > maxX || regionX < minX || regionZ > maxZ || regionZ < minZ) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return "prune-world-now";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(((RequiredArgumentBuilder)IMCCommand.newArgument(COMMAND_STAGE, IntegerArgumentType.integer((int)1)).executes(this::executeWithPage)).then(IMCCommand.newArgument(RADIUS_ARG, IntegerArgumentType.integer((int)100, (int)5000)).executes(this::executeWithPage)))).executes(this::checkPreConditionAndExecute);
    }
}

