/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCOPCommand;
import com.minecolonies.coremod.util.BackUpHelper;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class CommandExportColony
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        int colonyId = IntegerArgumentType.getInteger(context, (String)"colonyID");
        BackUpHelper.backupColonyData();
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyId, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).m_81372_().m_46472_());
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.colonyidnotfound", new Object[]{colonyId}), true);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.export.success", new Object[]{BackUpHelper.exportColony(colony)}), true);
        return 1;
    }

    @Override
    public String getName() {
        return "export";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute));
    }
}

