/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.coremod.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CommandChangeOwner
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        GameProfile profile;
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).m_81372_().m_46472_());
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.colonyidnotfound", new Object[]{colonyID}), true);
            return 0;
        }
        try {
            profile = GameProfileArgument.m_94590_(context, (String)"playername").stream().findFirst().orElse(null);
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11259_(profile.getId());
        if (player == null) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.playernotfound", new Object[]{profile.getName()}), true);
            return 0;
        }
        colony.getPermissions().setOwner((Player)player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.ownerchange.success", new Object[]{profile.getName(), colony.getName()}), true);
        return 1;
    }

    @Override
    public String getName() {
        return "setowner";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("playername", GameProfileArgument.m_94584_()).executes(this::checkPreConditionAndExecute)));
    }
}

