/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.citizencommands;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class CommandCitizenTeleport
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        Entity sender = ((CommandSourceStack)context.getSource()).m_81373_();
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)(sender == null ? Level.f_46428_ : ((CommandSourceStack)context.getSource()).m_81372_().m_46472_()));
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.colonyidnotfound", new Object[]{colonyID}), true);
            return 0;
        }
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(IntegerArgumentType.getInteger(context, (String)"citizenID"));
        if (citizenData == null) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.citizeninfo.notfound"), true);
            return 0;
        }
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (!optionalEntityCitizen.isPresent()) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.citizeninfo.notloaded"), true);
            return 0;
        }
        AbstractEntityCitizen entityCitizen = optionalEntityCitizen.get();
        Coordinates targetLocation = Vec3Argument.m_120849_(context, (String)"location");
        BlockPos targetPos = targetLocation.m_119568_((CommandSourceStack)context.getSource());
        if (((CommandSourceStack)context.getSource()).m_81372_() == entityCitizen.f_19853_) {
            entityCitizen.m_7678_(targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_(), entityCitizen.m_5675_(1.0f), entityCitizen.m_5686_(1.0f));
            entityCitizen.getNavigation().m_26573_();
        }
        return 1;
    }

    @Override
    public String getName() {
        return "teleport";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("citizenID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("location", Vec3Argument.m_120841_()).executes(this::checkPreConditionAndExecute))));
    }
}

