/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.citizencommands;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.level.Level;

public class CommandCitizenInfo
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        Entity sender = ((CommandSourceStack)context.getSource()).m_81373_();
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)(sender == null ? Level.f_46428_ : ((CommandSourceStack)context.getSource()).m_81372_().m_46472_()));
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.colonyidnotfound", new Object[]{colonyID}), true);
            return 0;
        }
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(IntegerArgumentType.getInteger(context, (String)"citizenID"));
        if (citizenData == null) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.citizeninfo.notfound"), true);
            return 0;
        }
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (!optionalEntityCitizen.isPresent()) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.citizeninfo.notloaded"), true);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.citizeninfo.desc", new Object[]{citizenData.getId(), citizenData.getName()}), true);
        AbstractEntityCitizen entityCitizen = optionalEntityCitizen.get();
        BlockPos citizenPosition = entityCitizen.m_142538_();
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.citizeninfo.pos", new Object[]{citizenPosition.m_123341_(), citizenPosition.m_123342_(), citizenPosition.m_123343_()}), true);
        BlockPos homePosition = entityCitizen.m_21534_();
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.citizeninfo.homepos", new Object[]{homePosition.m_123341_(), homePosition.m_123342_(), homePosition.m_123343_()}), true);
        if (entityCitizen.getCitizenColonyHandler().getWorkBuilding() == null) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.citizeninfo.workposnull"), true);
        } else {
            BlockPos workingPosition = entityCitizen.getCitizenColonyHandler().getWorkBuilding().getPosition();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.citizeninfo.workpos", new Object[]{workingPosition.m_123341_(), workingPosition.m_123342_(), workingPosition.m_123343_()}), true);
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.citizeninfo.health", new Object[]{Float.valueOf(entityCitizen.m_21223_()), Float.valueOf(entityCitizen.m_21233_())}), true);
        Object[] skills = new Object[]{citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Athletics).m_14418_(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Dexterity).m_14418_(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Strength).m_14418_(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Agility).m_14418_(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Stamina).m_14418_(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Mana).m_14418_(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Adaptability).m_14418_(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Focus).m_14418_(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Creativity).m_14418_(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Knowledge).m_14418_(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Intelligence).m_14418_()};
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.citizeninfo.skills", skills), true);
        if (entityCitizen.getCitizenJobHandler().getColonyJob() == null) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.citizeninfo.jobnull"), true);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.citizeninfo.noactivity"), true);
        } else if (entityCitizen.getCitizenColonyHandler().getWorkBuilding() != null && entityCitizen.getCitizenColonyHandler().getWorkBuilding().hasModule(WorkerBuildingModule.class)) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.citizeninfo.job", new Object[]{entityCitizen.getCitizenColonyHandler().getWorkBuilding().getFirstModuleOccurance(WorkerBuildingModule.class).getJobEntry().getTranslationKey()}), true);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("com.minecolonies.command.citizeninfo.activity", new Object[]{entityCitizen.getDesiredActivity(), entityCitizen.getCitizenJobHandler().getColonyJob().getNameTagDescription(), ((WrappedGoal)entityCitizen.f_21345_.m_25386_().findFirst().get()).m_26015_().toString()}), true);
        }
        return 1;
    }

    @Override
    public String getName() {
        return "info";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("citizenID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute)));
    }
}

