/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders.view;

import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.workorders.view.AbstractWorkOrderView;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.NotNull;

public class WorkOrderBuildingView
extends AbstractWorkOrderView {
    private String customBuildingName;
    private String customParentBuildingName;
    private String parentTranslationKey;

    @Override
    public Component getDisplayName() {
        TranslatableComponent nameComponent;
        TranslatableComponent buildingComponent;
        Object object = buildingComponent = this.customBuildingName.isEmpty() ? new TranslatableComponent(this.getWorkOrderName()) : new TextComponent(this.customBuildingName);
        if (this.parentTranslationKey.isEmpty()) {
            nameComponent = buildingComponent;
        } else {
            TranslatableComponent parentComponent = this.customParentBuildingName.isEmpty() ? new TranslatableComponent(this.parentTranslationKey) : new TextComponent(this.customParentBuildingName);
            nameComponent = new TranslatableComponent("%s / %s", new Object[]{parentComponent, buildingComponent});
        }
        return this.getOrderTypePrefix((Component)nameComponent);
    }

    private Component getOrderTypePrefix(Component nameComponent) {
        switch (this.getWorkOrderType()) {
            case BUILD: {
                return new TranslatableComponent("com.minecolonies.coremod.action.builder.building", new Object[]{nameComponent});
            }
            case UPGRADE: {
                return new TranslatableComponent("com.minecolonies.coremod.action.builder.upgrading", new Object[]{nameComponent, this.getCurrentLevel(), this.getTargetLevel()});
            }
            case REPAIR: {
                return new TranslatableComponent("com.minecolonies.coremod.action.builder.repairing", new Object[]{nameComponent});
            }
            case REMOVE: {
                return new TranslatableComponent("com.minecolonies.coremod.action.builder.removing", new Object[]{nameComponent});
            }
        }
        return nameComponent;
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        super.deserialize(buf);
        this.customBuildingName = buf.m_130136_(Short.MAX_VALUE);
        this.customParentBuildingName = buf.m_130136_(Short.MAX_VALUE);
        this.parentTranslationKey = buf.m_130136_(Short.MAX_VALUE);
    }

    @Override
    public boolean shouldShowIn(IBuildingView view) {
        return view instanceof ITownHallView || view instanceof BuildingBuilder.View;
    }
}

