/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.constant.SerializationIdentifierConstants;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.crafting.CustomRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CustomRecipeFactory
implements IFactory<FactoryVoidInput, CustomRecipe> {
    private static final String CUSTOM_RECIPE_ID_PROP = "id";

    @Override
    @NotNull
    public CustomRecipe getNewInstance(@NotNull IFactoryController factoryController, @NotNull FactoryVoidInput factoryVoidInput, Object ... context) throws IllegalArgumentException {
        if (context.length != 8 && context.length != 13) {
            throw new IllegalArgumentException("Unsupported context - Not correct number of parameters. Only 8 or 13are allowed!");
        }
        if (!(context[0] instanceof String)) {
            throw new IllegalArgumentException("Unsupported context - Invalid Crafter Recipe crafter");
        }
        if (!(context[5] instanceof ResourceLocation && context[6] instanceof ResourceLocation && context[7] instanceof ResourceLocation)) {
            throw new IllegalArgumentException("Unsupported context - Invalid ResourceLocation");
        }
        if (!(context[8] instanceof ResourceLocation)) {
            throw new IllegalArgumentException("Unsupported context - Invalid ResourceLocation");
        }
        if (!(context[9] instanceof List && context[11] instanceof List && context[12] instanceof List)) {
            throw new IllegalArgumentException("Unsupported context - Invalid Item Information");
        }
        return this.getNewInstance((String)context[0], (Integer)context[1], (Integer)context[2], (Boolean)context[3], (Boolean)context[4], (ResourceLocation)context[5], (ResourceLocation)context[6], (ResourceLocation)context[7], (ResourceLocation)context[8], (List)context[9], (ItemStack)context[10], (List)context[11], (List)context[12], (Block)context[13]);
    }

    private CustomRecipe getNewInstance(String crafter, int minBldgLevel, int maxBldgLevel, boolean mustExist, boolean showTooltip, ResourceLocation recipeId, ResourceLocation researchReq, ResourceLocation researchExclude, ResourceLocation lootTable, List<ItemStorage> inputs, ItemStack primaryOutput, List<ItemStack> secondaryOutput, List<ItemStack> altOutputs, Block intermediate) {
        return new CustomRecipe(crafter, minBldgLevel, maxBldgLevel, mustExist, showTooltip, recipeId, researchReq, researchExclude, lootTable, inputs, primaryOutput, secondaryOutput, altOutputs, intermediate);
    }

    @Override
    @NotNull
    public TypeToken<CustomRecipe> getFactoryOutputType() {
        return TypeToken.of(CustomRecipe.class);
    }

    @Override
    @NotNull
    public TypeToken<FactoryVoidInput> getFactoryInputType() {
        return TypeConstants.FACTORYVOIDINPUT;
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull CustomRecipe recipe) {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("crafter", recipe.getCrafter());
        compound.m_128359_(CUSTOM_RECIPE_ID_PROP, recipe.getRecipeStorage().getRecipeSource().toString());
        if (recipe.getRequiredResearchId() != null) {
            compound.m_128359_("research-id", recipe.getRequiredResearchId().toString());
        }
        if (recipe.getExcludedResearchId() != null) {
            compound.m_128359_("not-research-id", recipe.getExcludedResearchId().toString());
        }
        if (recipe.getLootTable() != null) {
            compound.m_128359_("loot-table", recipe.getLootTable().toString());
        }
        compound.m_128405_("min-building-level", recipe.getMinBuildingLevel());
        compound.m_128405_("max-building-level", recipe.getMaxBuildingLevel());
        compound.m_128379_("must-exist", recipe.getMustExist());
        compound.m_128379_("show-tooltip", recipe.getShowTooltip());
        ListTag inputs = new ListTag();
        for (ItemStorage in : recipe.getInputs()) {
            inputs.add((Object)controller.serialize(in));
        }
        compound.m_128365_("inputs", (Tag)inputs);
        compound.m_128365_("result", (Tag)recipe.getPrimaryOutput().m_41739_(new CompoundTag()));
        if (recipe.getSecondaryOutput().size() > 0) {
            ListTag secondaryOutputs = new ListTag();
            for (ItemStack is : recipe.getSecondaryOutput()) {
                secondaryOutputs.add((Object)is.m_41739_(new CompoundTag()));
            }
            compound.m_128365_("additional-output", (Tag)secondaryOutputs);
        }
        if (recipe.getAltOutputs().size() > 0) {
            ListTag altOutputs = new ListTag();
            for (ItemStack is : recipe.getAltOutputs()) {
                altOutputs.add((Object)is.m_41739_(new CompoundTag()));
            }
            compound.m_128365_("alternate-output", (Tag)altOutputs);
        }
        compound.m_128359_("intermediate", recipe.getIntermediate().getRegistryName().toString());
        return compound;
    }

    @Override
    @NotNull
    public CustomRecipe deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        String crafter = nbt.m_128461_("crafter");
        ResourceLocation recipeId = nbt.m_128403_(CUSTOM_RECIPE_ID_PROP) ? new ResourceLocation(nbt.m_128461_(CUSTOM_RECIPE_ID_PROP)) : null;
        ResourceLocation researchReq = nbt.m_128403_("research-id") ? new ResourceLocation(nbt.m_128461_("research-id")) : null;
        ResourceLocation researchExclude = nbt.m_128403_("not-research-id") ? new ResourceLocation(nbt.m_128461_("not-research-id")) : null;
        ResourceLocation lootTable = nbt.m_128403_("loot-table") ? new ResourceLocation(nbt.m_7916_()) : null;
        int minBldgLevel = nbt.m_128451_("min-building-level");
        int maxBldgLevel = nbt.m_128451_("max-building-level");
        boolean mustExist = nbt.m_128471_("must-exist");
        boolean showTooltip = nbt.m_128471_("show-tooltip");
        ListTag inputList = nbt.m_128437_("inputs", 10);
        ArrayList<ItemStorage> inputs = new ArrayList<ItemStorage>();
        for (Tag input : inputList) {
            if (!(input instanceof CompoundTag)) continue;
            inputs.add((ItemStorage)controller.deserialize((CompoundTag)input));
        }
        ItemStack primaryOutput = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("result"));
        ListTag secondaryList = nbt.m_128437_("additional-output", 10);
        ArrayList<ItemStack> secondaryOutput = new ArrayList<ItemStack>();
        for (Tag secondary : secondaryList) {
            if (!(secondary instanceof CompoundTag)) continue;
            secondaryOutput.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)secondary)));
        }
        ListTag altList = nbt.m_128437_("alternate-output", 10);
        ArrayList<ItemStack> altOutputs = new ArrayList<ItemStack>();
        for (Tag alt : altList) {
            if (!(alt instanceof CompoundTag)) continue;
            secondaryOutput.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)alt)));
        }
        Block intermediate = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128423_("intermediate").m_7916_()));
        return this.getNewInstance(crafter, minBldgLevel, maxBldgLevel, mustExist, showTooltip, recipeId, researchReq, researchExclude, lootTable, inputs, primaryOutput, secondaryOutput, altOutputs, intermediate);
    }

    @Override
    public void serialize(@NotNull IFactoryController controller, CustomRecipe recipe, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130070_(recipe.getCrafter());
        packetBuffer.m_130085_(recipe.getRecipeStorage().getRecipeSource());
        packetBuffer.writeBoolean(recipe.getRequiredResearchId() != null);
        if (recipe.getRequiredResearchId() != null) {
            packetBuffer.m_130085_(recipe.getRequiredResearchId());
        }
        packetBuffer.writeBoolean(recipe.getExcludedResearchId() != null);
        if (recipe.getExcludedResearchId() != null) {
            packetBuffer.m_130085_(recipe.getExcludedResearchId());
        }
        packetBuffer.writeBoolean(recipe.getLootTable() != null);
        if (recipe.getLootTable() != null) {
            packetBuffer.m_130085_(recipe.getLootTable());
        }
        packetBuffer.m_130130_(recipe.getMinBuildingLevel());
        packetBuffer.m_130130_(recipe.getMaxBuildingLevel());
        packetBuffer.writeBoolean(recipe.getMustExist());
        packetBuffer.writeBoolean(recipe.getShowTooltip());
        packetBuffer.m_130130_(recipe.getInputs().size());
        for (ItemStorage input : recipe.getInputs()) {
            controller.serialize(packetBuffer, input);
        }
        packetBuffer.m_130055_(recipe.getPrimaryOutput());
        packetBuffer.m_130130_(recipe.getSecondaryOutput().size());
        for (ItemStack secondary : recipe.getSecondaryOutput()) {
            packetBuffer.m_130055_(secondary);
        }
        packetBuffer.m_130130_(recipe.getAltOutputs().size());
        for (ItemStack alts : recipe.getAltOutputs()) {
            packetBuffer.m_130055_(alts);
        }
        packetBuffer.m_130085_(recipe.getIntermediate().getRegistryName());
    }

    @Override
    @NotNull
    public CustomRecipe deserialize(@NotNull IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
        String crafter = buffer.m_130277_();
        ResourceLocation recipeId = buffer.m_130281_();
        ResourceLocation researchReq = buffer.readBoolean() ? buffer.m_130281_() : null;
        ResourceLocation researchExclude = buffer.readBoolean() ? buffer.m_130281_() : null;
        ResourceLocation lootTable = buffer.readBoolean() ? buffer.m_130281_() : null;
        int minBldgLevel = buffer.m_130242_();
        int maxBldgLevel = buffer.m_130242_();
        boolean mustExist = buffer.readBoolean();
        boolean showTooltip = buffer.readBoolean();
        ArrayList<ItemStorage> inputs = new ArrayList<ItemStorage>();
        for (int numInputs = buffer.m_130242_(); numInputs > 0; --numInputs) {
            inputs.add((ItemStorage)controller.deserialize(buffer));
        }
        ItemStack primaryOutput = buffer.m_130267_();
        ArrayList<ItemStack> secondaryOutput = new ArrayList<ItemStack>();
        for (int numSec = buffer.m_130242_(); numSec > 0; --numSec) {
            secondaryOutput.add(buffer.m_130267_());
        }
        ArrayList<ItemStack> altOutputs = new ArrayList<ItemStack>();
        for (int numAlts = buffer.m_130242_(); numAlts > 0; --numAlts) {
            altOutputs.add(buffer.m_130267_());
        }
        Block intermediate = (Block)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_());
        return this.getNewInstance(crafter, minBldgLevel, maxBldgLevel, mustExist, showTooltip, recipeId, researchReq, researchExclude, lootTable, inputs, primaryOutput, secondaryOutput, altOutputs, intermediate);
    }

    @Override
    public short getSerializationId() {
        return SerializationIdentifierConstants.CUSTOM_RECIPE_ID;
    }
}

