/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.TagConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.AbstractDOCraftingBuildingModule;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BuildingSawmill
extends AbstractBuilding {
    protected static final String SAWMILL = "sawmill";
    private static final double MIN_PERCENTAGE_TO_CRAFT = 0.75;

    public BuildingSawmill(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SAWMILL;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public static class DOCraftingModule
    extends AbstractDOCraftingBuildingModule {
        public DOCraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_SAWMILL).combine(stack -> Optional.of(stack.m_204117_(ItemTags.f_13168_) || stack.m_204117_(ItemTags.f_13182_)));
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_SAWMILL).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            Optional<Boolean> isRecipeAllowed = CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, TagConstants.CRAFTING_SAWMILL);
            if (isRecipeAllowed.isPresent()) {
                return isRecipeAllowed.get();
            }
            double amountOfValidBlocks = 0.0;
            double blocks = 0.0;
            for (List<ItemStack> stacks : recipe.getInputs()) {
                ItemStack stack;
                if (stacks.isEmpty() || ItemStackUtils.isEmpty(stack = stacks.get(0)).booleanValue()) continue;
                if (stack.m_204117_(ItemTags.f_13168_) || stack.m_204117_(ItemTags.f_13182_)) {
                    amountOfValidBlocks += (double)stack.m_41613_();
                    continue;
                }
                for (TagKey tag : stack.m_204131_().toList()) {
                    if (!tag.f_203868_().m_135815_().contains("wood")) continue;
                    amountOfValidBlocks += (double)stack.m_41613_();
                    break;
                }
                blocks += (double)stack.m_41613_();
            }
            return amountOfValidBlocks > 0.0 && amountOfValidBlocks / blocks > 0.75;
        }
    }
}

