/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Disease;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.entity.ai.citizen.healer.Patient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BuildingHospital
extends AbstractBuilding {
    private static final String HOSPITAL_DESC = "hospital";
    private static final int MAX_BUILDING_LEVEL = 5;
    @NotNull
    private final Map<BlockPos, Integer> bedMap = new HashMap<BlockPos, Integer>();
    private final Map<Integer, Patient> patients = new HashMap<Integer, Patient>();

    public BuildingHospital(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return HOSPITAL_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        ListTag bedTagList = compound.m_128437_("beds", 10);
        for (int i = 0; i < bedTagList.size(); ++i) {
            CompoundTag bedCompound = bedTagList.m_128728_(i);
            BlockPos bedPos = BlockPosUtil.read(bedCompound, "pos");
            if (this.bedMap.containsKey(bedPos)) continue;
            this.bedMap.put(bedPos, bedCompound.m_128451_("id"));
        }
        ListTag patientTagList = compound.m_128437_("patients", 10);
        for (int i = 0; i < patientTagList.size(); ++i) {
            CompoundTag patientCompound = patientTagList.m_128728_(i);
            int patientId = patientCompound.m_128451_("id");
            if (this.patients.containsKey(patientId)) continue;
            this.patients.put(patientId, new Patient(patientCompound));
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        if (!this.bedMap.isEmpty()) {
            @NotNull ListTag bedTagList = new ListTag();
            for (Map.Entry<BlockPos, Integer> entry : this.bedMap.entrySet()) {
                CompoundTag bedCompound = new CompoundTag();
                BlockPosUtil.write(bedCompound, "pos", entry.getKey());
                bedCompound.m_128405_("id", entry.getValue().intValue());
                bedTagList.add((Object)bedCompound);
            }
            compound.m_128365_("beds", (Tag)bedTagList);
        }
        if (!this.patients.isEmpty()) {
            @NotNull ListTag patientTagList = new ListTag();
            for (Patient patient : this.patients.values()) {
                CompoundTag patientCompound = new CompoundTag();
                patient.write(patientCompound);
                patientTagList.add((Object)patientCompound);
            }
            compound.m_128365_("patients", (Tag)patientTagList);
        }
        return compound;
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull Level world) {
        super.registerBlockPosition(blockState, pos, world);
        BlockPos registrationPosition = pos;
        if (blockState.m_60734_() instanceof BedBlock) {
            if (blockState.m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT) {
                registrationPosition = registrationPosition.m_142300_((Direction)blockState.m_61143_((Property)BedBlock.f_54117_));
            }
            if (!this.bedMap.containsKey(registrationPosition)) {
                this.bedMap.put(registrationPosition, 0);
            }
        }
    }

    @NotNull
    public List<BlockPos> getBedList() {
        return ImmutableList.copyOf(this.bedMap.keySet());
    }

    public List<Patient> getPatients() {
        return ImmutableList.copyOf(this.patients.values());
    }

    public void removePatientFile(Patient patient) {
        this.patients.remove(patient.getId());
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> map = super.getRequiredItemsAndAmount();
        map.put(this::doesAnyPatientRequireStack, (Tuple<Integer, Boolean>)new Tuple((Object)10, (Object)false));
        return map;
    }

    private boolean doesAnyPatientRequireStack(ItemStack stack) {
        for (Patient patient : this.patients.values()) {
            String diseaseName;
            ICitizenData data = this.colony.getCitizenManager().getCivilian(patient.getId());
            if (data == null || !data.getEntity().isPresent() || !data.getEntity().get().getCitizenDiseaseHandler().isSick() || (diseaseName = data.getEntity().get().getCitizenDiseaseHandler().getDisease()).isEmpty()) continue;
            Disease disease = IColonyManager.getInstance().getCompatibilityManager().getDisease(diseaseName);
            for (ItemStack cure : disease.getCure()) {
                if (!cure.m_41656_(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public void checkOrCreatePatientFile(int citizenId) {
        if (!this.patients.containsKey(citizenId)) {
            this.patients.put(citizenId, new Patient(citizenId));
        }
    }

    public void registerPatient(BlockPos bedPos, int citizenId) {
        this.bedMap.put(bedPos, citizenId);
        this.setBedOccupation(bedPos, citizenId != 0);
    }

    private void setBedOccupation(BlockPos bedPos, boolean occupied) {
        BlockState state = this.colony.getWorld().m_8055_(bedPos);
        if (state.m_204336_(BlockTags.f_13038_)) {
            this.colony.getWorld().m_7731_(bedPos, (BlockState)state.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(occupied)), 3);
            BlockPos feetPos = bedPos.m_142300_(((Direction)state.m_61143_((Property)BedBlock.f_54117_)).m_122424_());
            BlockState feetState = this.colony.getWorld().m_8055_(feetPos);
            if (feetState.m_204336_(BlockTags.f_13038_)) {
                this.colony.getWorld().m_7731_(feetPos, (BlockState)feetState.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(occupied)), 3);
            }
        }
    }

    @Override
    public void onWakeUp() {
        for (Map.Entry<BlockPos, Integer> entry : new ArrayList<Map.Entry<BlockPos, Integer>>(this.bedMap.entrySet())) {
            BlockState state = this.colony.getWorld().m_8055_(entry.getKey());
            if (state.m_60734_() instanceof BedBlock) {
                if (entry.getValue() == 0 && ((Boolean)state.m_61143_((Property)BedBlock.f_49441_)).booleanValue()) {
                    this.setBedOccupation(entry.getKey(), false);
                    continue;
                }
                if (entry.getValue() == 0) continue;
                ICitizenData citizen = this.colony.getCitizenManager().getCivilian(entry.getValue());
                if (citizen != null) {
                    if (((Boolean)state.m_61143_((Property)BedBlock.f_49441_)).booleanValue()) {
                        if (citizen.isAsleep() && citizen.getEntity().isPresent() && !(citizen.getEntity().get().m_142538_().m_123331_((Vec3i)entry.getKey()) > 2.0)) continue;
                        this.setBedOccupation(entry.getKey(), false);
                        this.bedMap.put(entry.getKey(), 0);
                        continue;
                    }
                    if (!citizen.isAsleep() || !citizen.getEntity().isPresent() || !(citizen.getEntity().get().m_142538_().m_123331_((Vec3i)entry.getKey()) < 2.0)) continue;
                    this.setBedOccupation(entry.getKey(), true);
                    continue;
                }
                this.bedMap.put(entry.getKey(), 0);
                continue;
            }
            this.bedMap.remove(entry.getKey());
        }
    }

    @Override
    public boolean canEat(ItemStack stack) {
        for (Disease disease : IColonyManager.getInstance().getCompatibilityManager().getDiseases()) {
            for (ItemStack cure : disease.getCure()) {
                if (!cure.m_41656_(stack)) continue;
                return false;
            }
        }
        return super.canEat(stack);
    }
}

