/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IDefinesCoreBuildingStatsModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.buildings.modules.stat.IStat;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.sounds.TavernSounds;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.huts.WindowHutLiving;
import com.minecolonies.coremod.colony.buildings.views.LivingBuildingView;
import com.minecolonies.coremod.colony.colonyEvents.citizenEvents.VisitorSpawnedEvent;
import com.minecolonies.coremod.colony.interactionhandling.RecruitmentInteraction;
import com.minecolonies.coremod.datalistener.CustomVisitorListener;
import com.minecolonies.coremod.network.messages.client.colony.PlayMusicAtPosMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class TavernBuildingModule
extends AbstractBuildingModule
implements IDefinesCoreBuildingStatsModule,
IBuildingEventsModule,
IPersistentModule,
ITickingModule {
    public static final String TAG_VISITOR_ID = "visitor";
    private static final int LEATHER_SKILL_LEVEL = 20;
    private static final int GOLD_SKILL_LEVEL = 25;
    private static final int IRON_SKILL_LEVEL = 30;
    private static final int DIAMOND_SKILL_LEVEL = 35;
    private static final int TWENTY_MINUTES = 24000;
    private static final String TAG_NOVISITTIME = "novisit";
    private int musicCooldown = 0;
    private final List<Integer> externalCitizens = new ArrayList<Integer>();
    private final List<BlockPos> sitPositions = new ArrayList<BlockPos>();
    private final List<BlockPos> workPositions = new ArrayList<BlockPos>();
    private boolean initTags = false;
    private int noVisitorTime = 10000;

    @Override
    public IStat<Integer> getMaxInhabitants() {
        if (this.building.getBuildingLevel() <= 0) {
            return prev -> 0;
        }
        return prev -> 4;
    }

    @Override
    public void onPlayerEnterBuilding(Player player) {
        if (this.musicCooldown <= 0 && this.building.getBuildingLevel() > 0 && !this.building.getColony().isDay()) {
            int count = 0;
            BlockPos avg = BlockPos.f_121853_;
            for (Integer id : this.externalCitizens) {
                Object data = this.building.getColony().getVisitorManager().getVisitor(id);
                if (data == null || data.getSittingPosition().equals((Object)BlockPos.f_121853_)) continue;
                ++count;
                avg = avg.m_141952_((Vec3i)data.getSittingPosition());
            }
            if (count < 2) {
                return;
            }
            avg = new BlockPos(avg.m_123341_() / count, avg.m_123342_() / count, avg.m_123343_() / count);
            PlayMusicAtPosMessage message = new PlayMusicAtPosMessage(TavernSounds.tavernTheme, avg, this.building.getColony().getWorld(), 0.7f, 1.0f);
            for (ServerPlayer curPlayer : this.building.getColony().getPackageManager().getCloseSubscribers()) {
                Network.getNetwork().sendToPlayer(message, curPlayer);
            }
            this.musicCooldown = 24000;
        }
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if (this.musicCooldown > 0) {
            this.musicCooldown -= 500;
        }
        this.externalCitizens.removeIf(id -> colony.getVisitorManager().getVisitor((int)id) == null);
        if (this.noVisitorTime > 0) {
            this.noVisitorTime -= 500;
        }
        if (this.building.getBuildingLevel() > 0 && this.externalCitizens.size() < 3 * this.building.getBuildingLevel() && this.noVisitorTime <= 0) {
            this.spawnVisitor();
            this.noVisitorTime = colony.getWorld().m_5822_().nextInt(3000) + 6000 / this.building.getBuildingLevel() * colony.getCitizenManager().getCurrentCitizenCount() / colony.getCitizenManager().getMaxCitizens();
        }
    }

    @Override
    public void onUpgradeComplete(int newlevel) {
        this.initTags = false;
    }

    private void spawnVisitor() {
        IVisitorData newCitizen = (IVisitorData)this.building.getColony().getVisitorManager().createAndRegisterCivilianData();
        this.externalCitizens.add(newCitizen.getId());
        newCitizen.setBedPos(this.building.getPosition());
        newCitizen.setHomeBuilding(this.building);
        int recruitLevel = this.building.getColony().getWorld().f_46441_.nextInt(10 * this.building.getBuildingLevel()) + 15;
        List<Tuple<Item, Integer>> recruitCosts = IColonyManager.getInstance().getCompatibilityManager().getRecruitmentCostsWeights();
        if (newCitizen.getName().contains("Ray")) {
            newCitizen.setRecruitCosts(new ItemStack((ItemLike)Items.f_42674_, 64));
        }
        newCitizen.getCitizenSkillHandler().init(recruitLevel);
        BlockPos spawnPos = BlockPosUtil.findSpawnPosAround(this.building.getColony().getWorld(), this.building.getPosition());
        if (spawnPos == null) {
            spawnPos = this.building.getPosition();
        }
        Tuple<Item, Integer> cost = recruitCosts.get(this.building.getColony().getWorld().f_46441_.nextInt(recruitCosts.size()));
        ItemStack boots = ItemStack.f_41583_;
        if (recruitLevel > 20) {
            boots = new ItemStack((ItemLike)Items.f_42463_);
        }
        if (recruitLevel > 25) {
            boots = new ItemStack((ItemLike)Items.f_42479_);
        }
        if (recruitLevel > 30) {
            if (cost.getB() <= 2) {
                cost = recruitCosts.get(this.building.getColony().getWorld().f_46441_.nextInt(recruitCosts.size()));
            }
            boots = new ItemStack((ItemLike)Items.f_42471_);
        }
        if (recruitLevel > 35) {
            if (cost.getB() <= 3) {
                cost = recruitCosts.get(this.building.getColony().getWorld().f_46441_.nextInt(recruitCosts.size()));
            }
            boots = new ItemStack((ItemLike)Items.f_42475_);
        }
        newCitizen.setRecruitCosts(new ItemStack((ItemLike)cost.getA(), (int)((double)recruitLevel * 3.0 / (double)cost.getB().intValue())));
        if (!CustomVisitorListener.chanceCustomVisitors(newCitizen)) {
            newCitizen.triggerInteraction(new RecruitmentInteraction((Component)new TranslatableComponent("com.minecolonies.coremod.gui.chat.recruitstory" + (this.building.getColony().getWorld().f_46441_.nextInt(20) + 1), new Object[]{newCitizen.getName().split(" ")[0]}), ChatPriority.IMPORTANT));
        }
        this.building.getColony().getVisitorManager().spawnOrCreateCivilian(newCitizen, this.building.getColony().getWorld(), spawnPos, true);
        if (newCitizen.getEntity().isPresent()) {
            newCitizen.getEntity().get().m_8061_(EquipmentSlot.FEET, boots);
        }
        this.building.getColony().getEventDescriptionManager().addEventDescription(new VisitorSpawnedEvent(spawnPos, newCitizen.getName()));
    }

    @Override
    public void serializeNBT(CompoundTag nbt) {
        ListTag visitorlist = new ListTag();
        for (Integer id : this.externalCitizens) {
            CompoundTag visitorCompound = new CompoundTag();
            visitorCompound.m_128405_(TAG_VISITOR_ID, id.intValue());
            visitorlist.add((Object)visitorCompound);
        }
        nbt.m_128365_("visitors", (Tag)visitorlist);
        nbt.m_128405_(TAG_NOVISITTIME, this.noVisitorTime);
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ListTag visitorlist = nbt.m_128437_("visitors", 10);
        for (Tag data : visitorlist) {
            int id = ((CompoundTag)data).m_128451_(TAG_VISITOR_ID);
            ICitizenData citizenData = (ICitizenData)this.building.getColony().getVisitorManager().getCivilian(id);
            if (citizenData == null) continue;
            this.externalCitizens.add(id);
            citizenData.setHomeBuilding(this.building);
        }
        this.noVisitorTime = nbt.m_128451_(TAG_NOVISITTIME);
    }

    public BlockPos getFreeSitPosition() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(this.getSitPositions());
        if (positions.isEmpty()) {
            return null;
        }
        for (Integer id : this.externalCitizens) {
            Object data = this.building.getColony().getVisitorManager().getVisitor(id);
            if (data == null) continue;
            positions.remove(data.getSittingPosition());
        }
        if (!positions.isEmpty()) {
            return (BlockPos)positions.get(this.building.getColony().getWorld().f_46441_.nextInt(positions.size()));
        }
        return null;
    }

    @Override
    public void onDestroyed() {
        for (Integer id : this.externalCitizens) {
            this.building.getColony().getVisitorManager().removeCivilian((ICivilianData)this.building.getColony().getVisitorManager().getVisitor(id));
        }
    }

    public List<Integer> getExternalCitizens() {
        return this.externalCitizens;
    }

    public BlockPos getWorkPos() {
        if (!this.getWorkPositions().isEmpty()) {
            return this.workPositions.get(this.building.getColony().getWorld().f_46441_.nextInt(this.workPositions.size()));
        }
        return null;
    }

    private List<BlockPos> getSitPositions() {
        this.initTagPositions();
        return this.sitPositions;
    }

    private List<BlockPos> getWorkPositions() {
        this.initTagPositions();
        return this.workPositions;
    }

    public void initTagPositions() {
        if (this.initTags) {
            return;
        }
        AbstractTileEntityColonyBuilding te = this.building.getTileEntity();
        if (te != null) {
            this.initTags = true;
            for (Map.Entry entry : te.getWorldTagPosMap().entrySet()) {
                if (((List)entry.getValue()).contains("sit")) {
                    this.sitPositions.add((BlockPos)entry.getKey());
                }
                if (!((List)entry.getValue()).contains("work")) continue;
                this.workPositions.add((BlockPos)entry.getKey());
            }
        }
    }

    public boolean removeCitizen(Integer id) {
        this.externalCitizens.remove(id);
        return false;
    }

    public void setNoVisitorTime(int noVisitorTime) {
        this.noVisitorTime = noVisitorTime;
    }

    public static class View
    extends LivingBuildingView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public BOWindow getWindow() {
            return new WindowHutLiving(this);
        }
    }
}

