/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IEntityListModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class EntityListModule
extends AbstractBuildingModule
implements IEntityListModule,
IPersistentModule {
    private static final String TAG_MOBLIST = "newmoblist";
    private final Set<ResourceLocation> mobsAllowed = new HashSet<ResourceLocation>();
    private final String id;

    public EntityListModule(String id) {
        this.id = id;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        ListTag filterableList = compound.m_128469_(this.id).m_128437_(TAG_MOBLIST, 8);
        for (int i = 0; i < filterableList.size(); ++i) {
            ResourceLocation res = new ResourceLocation(filterableList.m_128778_(i));
            if (!ForgeRegistries.ENTITIES.containsKey(res)) continue;
            this.mobsAllowed.add(res);
        }
    }

    @Override
    public void serializeNBT(CompoundTag compound) {
        CompoundTag moduleCompound = new CompoundTag();
        @NotNull ListTag filteredMobs = new ListTag();
        for (ResourceLocation mob : this.mobsAllowed) {
            filteredMobs.add((Object)StringTag.m_129297_((String)mob.toString()));
        }
        moduleCompound.m_128365_(TAG_MOBLIST, (Tag)filteredMobs);
        compound.m_128365_(this.id, (Tag)moduleCompound);
    }

    @Override
    public void addEntity(ResourceLocation item) {
        this.mobsAllowed.add(item);
        this.markDirty();
    }

    @Override
    public boolean isEntityInList(ResourceLocation entity) {
        return this.mobsAllowed.contains(entity);
    }

    @Override
    public void removeEntity(ResourceLocation item) {
        this.mobsAllowed.remove(item);
        this.markDirty();
    }

    public ImmutableList<ResourceLocation> getList() {
        return ImmutableList.copyOf(this.mobsAllowed);
    }

    @Override
    public String getListIdentifier() {
        return this.id;
    }

    @Override
    public void serializeToView(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.mobsAllowed.size());
        for (ResourceLocation entity : this.mobsAllowed) {
            buf.writeRegistryIdUnsafe(ForgeRegistries.ENTITIES, entity);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }
}

