/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.townhall;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.blockui.views.SwitchView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.network.messages.PermissionsMessage;
import com.minecolonies.coremod.network.messages.server.colony.ChangeFreeToInteractBlockMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class WindowPermissionsPage
extends AbstractWindowTownHall {
    @NotNull
    private final List<ColonyPlayer> users = new ArrayList<ColonyPlayer>();
    private ScrollingList userList;
    private ScrollingList actionsList;
    private ScrollingList freeBlocksList;
    private final ScrollingList rankButtonList;
    private final List<Rank> rankList = new LinkedList<Rank>();
    private final List<Rank> allRankList = new LinkedList<Rank>();
    private Rank actionsRank;
    private List<Action> actions = new ArrayList<Action>();
    private Map<Integer, String> rankTypes = new HashMap<Integer, String>();

    public WindowPermissionsPage(BuildingTownHall.View building) {
        super(building, "layoutpermissions.xml");
        this.actions.addAll(Arrays.asList(Action.values()));
        this.rankTypes.put(0, "com.minecolonies.coremod.gui.townhall.ranktype.colonymanager");
        this.rankTypes.put(1, "com.minecolonies.coremod.gui.townhall.ranktype.hostile");
        this.rankTypes.put(2, "com.minecolonies.coremod.gui.townhall.ranktype.none");
        this.actionsRank = building.getColony().getPermissions().getRankOfficer();
        ((Button)this.findPaneOfTypeByID("removeRank", Button.class)).setEnabled(false);
        this.rankButtonList = (ScrollingList)this.findPaneOfTypeByID("rankButtonList", ScrollingList.class);
        this.actionsList = (ScrollingList)this.findPaneOfTypeByID("rankList", ScrollingList.class);
        this.updateUsers();
        this.registerButton("addPlayer", this::addPlayerCLicked);
        this.registerButton("removePlayer", this::removePlayerClicked);
        this.registerButton("trigger", this::trigger);
        this.registerButton("addBlock", this::addBlock);
        this.registerButton("removeBlock", this::removeBlock);
        this.registerButton("buttonAddRank", this::addRank);
        this.registerButton("rankButton", this::onRankButtonClicked);
        this.registerButton("removeRank", this::onRemoveRankButtonClicked);
        this.registerButton("permissionsModeToggle", this::togglePermMode);
        this.registerButton("setSubscriber", this::setSubscriber);
    }

    private void setSubscriber(Button button) {
        Network.getNetwork().sendToServer(new PermissionsMessage.SetSubscriber(((ITownHallView)this.building).getColony(), this.actionsRank, !this.actionsRank.isSubscriber()));
        this.actionsRank.setSubscriber(!this.actionsRank.isSubscriber());
        button.setText((MutableComponent)new TranslatableComponent(this.actionsRank.isSubscriber() ? "com.minecolonies.coremod.gui.workerhuts.retrieveon" : "com.minecolonies.coremod.gui.workerhuts.retrieveoff"));
    }

    private void changeRankMode(DropDownList dropdown) {
        Network.getNetwork().sendToServer(new PermissionsMessage.EditRankType(((ITownHallView)this.building).getColony(), this.actionsRank, dropdown.getSelectedIndex()));
    }

    private void togglePermMode(Button button) {
        SwitchView permSwitch;
        permSwitch.setView((permSwitch = (SwitchView)this.findPaneOfTypeByID("permissionsManagement", SwitchView.class)).getCurrentView() != null && permSwitch.getCurrentView().getID().equals("permissionsList") ? "permissionsSettings" : "permissionsList");
        if (permSwitch.getCurrentView().getID().equals("permissionsSettings")) {
            DropDownList dropdown = (DropDownList)this.findPaneOfTypeByID("rankTypePicker", DropDownList.class);
            dropdown.setDataProvider(new DropDownList.DataProvider(){

                public int getElementCount() {
                    return WindowPermissionsPage.this.rankTypes.size();
                }

                public String getLabel(int i) {
                    return new TranslatableComponent(WindowPermissionsPage.this.rankTypes.get(i)).getString();
                }
            });
            dropdown.setHandler(this::changeRankMode);
            dropdown.setSelectedIndex(this.actionsRank.isColonyManager() ? 0 : (this.actionsRank.isHostile() ? 1 : 2));
            ((Button)this.findPaneOfTypeByID("setSubscriber", Button.class)).setText((MutableComponent)new TranslatableComponent(this.actionsRank.isSubscriber() ? "com.minecolonies.coremod.gui.workerhuts.retrieveon" : "com.minecolonies.coremod.gui.workerhuts.retrieveoff"));
        }
    }

    private void addRank() {
        Text label = (Text)this.findPaneOfTypeByID("rankNameError", Text.class);
        TextField input = (TextField)this.findPaneOfTypeByID("addRankName", TextField.class);
        if (this.isValidRankname(input.getText())) {
            Network.getNetwork().sendToServer(new PermissionsMessage.AddRank(((ITownHallView)this.building).getColony(), input.getText()));
            input.setText("");
            label.hide();
        } else {
            label.show();
        }
    }

    private boolean isValidRankname(String name) {
        if (name.equals("")) {
            return false;
        }
        for (Rank rank : this.rankList) {
            if (!rank.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    private void onRemoveRankButtonClicked(Button button) {
        if (this.actionsRank != null) {
            Network.getNetwork().sendToServer(new PermissionsMessage.RemoveRank(((ITownHallView)this.building).getColony(), this.actionsRank));
            ((ITownHallView)this.building).getColony().getPermissions().removeRank(this.actionsRank);
            this.actionsRank = ((ITownHallView)this.building).getColony().getPermissions().getRankOfficer();
            button.setEnabled(false);
        }
    }

    private void updateUsers() {
        this.users.clear();
        this.users.addAll(((ITownHallView)this.building).getColony().getPlayers().values());
        this.users.sort(Comparator.comparing(ColonyPlayer::getRank, Rank::compareTo));
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.fillUserList();
        this.fillFreeBlockList();
        this.fillRanks();
        this.fillPermissionList();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Text label = (Text)this.findPaneOfTypeByID("permissionError", Text.class);
        Button button = (Button)this.findPaneOfTypeByID("addPlayer", Button.class);
        if (((ITownHallView)this.building).getColony().getPermissions().hasPermission((Player)player, Action.EDIT_PERMISSIONS)) {
            label.hide();
            button.setEnabled(true);
        } else {
            label.show();
            button.setEnabled(false);
        }
    }

    private void updateRanks() {
        this.rankList.clear();
        for (Rank rank : ((ITownHallView)this.building).getColony().getPermissions().getRanks().values()) {
            if (rank.equals(((ITownHallView)this.building).getColony().getPermissions().getRankOwner())) continue;
            this.rankList.add(rank);
        }
        this.allRankList.clear();
        this.allRankList.addAll(((ITownHallView)this.building).getColony().getPermissions().getRanks().values());
    }

    private void fillRanks() {
        this.rankButtonList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowPermissionsPage.this.allRankList.size();
            }

            public void updateElement(int i, Pane pane) {
                Rank rank = WindowPermissionsPage.this.allRankList.get(i);
                Button button = (Button)pane.findPaneOfTypeByID("rankButton", Button.class);
                button.setText(rank.getName());
                button.setEnabled(!rank.equals(WindowPermissionsPage.this.actionsRank));
                ((Text)pane.findPaneOfTypeByID("rankId", Text.class)).setText(Integer.toString(rank.getId()));
            }
        });
    }

    private void onRankButtonClicked(@NotNull Button button) {
        int rankId = this.rankButtonList.getListElementIndexByPane((Pane)button);
        Rank rank = this.allRankList.get(rankId);
        if (rank != null) {
            this.actionsRank = rank;
            button.setEnabled(false);
            ((Button)this.findPaneOfTypeByID("removeRank", Button.class)).setEnabled(!this.actionsRank.isInitial());
            ((SwitchView)this.findPaneOfTypeByID("permissionsManagement", SwitchView.class)).setView("permissionsList");
        }
    }

    private void removeBlock(Button button) {
        int row = this.freeBlocksList.getListElementIndexByPane((Pane)button);
        if (row >= 0) {
            @NotNull List<Block> freeBlocks = ((ITownHallView)this.building).getColony().getFreeBlocks();
            @NotNull List<BlockPos> freePositions = ((ITownHallView)this.building).getColony().getFreePositions();
            if (row < freeBlocks.size()) {
                Network.getNetwork().sendToServer(new ChangeFreeToInteractBlockMessage(((ITownHallView)this.building).getColony(), freeBlocks.get(row), ChangeFreeToInteractBlockMessage.MessageType.REMOVE_BLOCK));
                ((ITownHallView)this.building).getColony().removeFreeBlock(freeBlocks.get(row));
            } else if (row < freeBlocks.size() + freePositions.size()) {
                BlockPos freePos = freePositions.get(row - freeBlocks.size());
                Network.getNetwork().sendToServer(new ChangeFreeToInteractBlockMessage(((ITownHallView)this.building).getColony(), freePos, ChangeFreeToInteractBlockMessage.MessageType.REMOVE_BLOCK));
                ((ITownHallView)this.building).getColony().removeFreePosition(freePos);
            }
            this.fillFreeBlockList();
        }
    }

    private void fillFreeBlockList() {
        final @NotNull List<Block> freeBlocks = ((ITownHallView)this.building).getColony().getFreeBlocks();
        final @NotNull List<BlockPos> freePositions = ((ITownHallView)this.building).getColony().getFreePositions();
        this.freeBlocksList = (ScrollingList)this.findPaneOfTypeByID("blocks", ScrollingList.class);
        this.freeBlocksList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return freeBlocks.size() + freePositions.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                if (index < freeBlocks.size()) {
                    ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(((Block)freeBlocks.get(index)).getRegistryName().toString());
                } else {
                    BlockPos pos = (BlockPos)freePositions.get(index - freeBlocks.size());
                    ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_());
                }
            }
        });
    }

    private void addBlock() {
        TextField input = (TextField)this.findPaneOfTypeByID("addBlockName", TextField.class);
        String inputText = input.getText();
        try {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(inputText));
            if (block != null) {
                ((ITownHallView)this.building).getColony().addFreeBlock(block);
                Network.getNetwork().sendToServer(new ChangeFreeToInteractBlockMessage(((ITownHallView)this.building).getColony(), block, ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK));
            }
        }
        catch (ResourceLocationException block) {
            // empty catch block
        }
        BlockPos pos = BlockPosUtil.getBlockPosOfString(inputText);
        if (pos != null) {
            Network.getNetwork().sendToServer(new ChangeFreeToInteractBlockMessage(((ITownHallView)this.building).getColony(), pos, ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK));
            ((ITownHallView)this.building).getColony().addFreePosition(pos);
        }
        this.fillFreeBlockList();
        input.setText("");
    }

    private void trigger(@NotNull Button button) {
        int index = this.actionsList.getListElementIndexByPane((Pane)button);
        Action action = this.actions.get(index);
        IPermissions permissions = ((ITownHallView)this.building).getColony().getPermissions();
        LocalPlayer playerEntity = Minecraft.m_91087_().f_91074_;
        String key = button.getText() instanceof TranslatableComponent ? ((TranslatableComponent)button.getText()).m_131328_() : button.getTextAsString();
        boolean enable = !"com.minecolonies.coremod.gui.workerhuts.retrieveon".equals(key);
        button.disable();
        if (!permissions.alterPermission(permissions.getRank((Player)playerEntity), this.actionsRank, action, enable)) {
            return;
        }
        Network.getNetwork().sendToServer(new PermissionsMessage.Permission(((ITownHallView)this.building).getColony(), enable, this.actionsRank, action));
        if (!enable) {
            button.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.retrieveoff"));
        } else {
            button.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.retrieveon"));
        }
    }

    private void fillPermissionList() {
        this.actionsList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowPermissionsPage.this.actions.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                Action action = WindowPermissionsPage.this.actions.get(index);
                TranslatableComponent name = new TranslatableComponent("com.minecolonies.coremod.permission." + action.toString().toLowerCase(Locale.US));
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText((Component)name);
                boolean isTriggered = ((ITownHallView)WindowPermissionsPage.this.building).getColony().getPermissions().hasPermission(WindowPermissionsPage.this.actionsRank, action);
                Button onOffButton = (Button)rowPane.findPaneOfTypeByID("trigger", Button.class);
                onOffButton.setText((MutableComponent)(isTriggered ? new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.retrieveon") : new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.retrieveoff")));
                ((Text)rowPane.findPaneOfTypeByID("index", Text.class)).setText(Integer.toString(index));
                if (!((ITownHallView)WindowPermissionsPage.this.building).getColony().getPermissions().canAlterPermission(((ITownHallView)WindowPermissionsPage.this.building).getColony().getPermissions().getRank((Player)Minecraft.m_91087_().f_91074_), WindowPermissionsPage.this.actionsRank, action)) {
                    onOffButton.disable();
                } else {
                    onOffButton.enable();
                }
            }
        });
    }

    private void fillUserList() {
        this.userList = (ScrollingList)this.findPaneOfTypeByID("users", ScrollingList.class);
        this.userList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowPermissionsPage.this.users.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ColonyPlayer player = WindowPermissionsPage.this.users.get(index);
                Rank rank = player.getRank();
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(player.getName());
                DropDownList dropdown = (DropDownList)rowPane.findPaneOfTypeByID("rankPicker", DropDownList.class);
                int n = rank.getId();
                ((ITownHallView)WindowPermissionsPage.this.building).getColony().getPermissions();
                if (n == 0) {
                    ((Button)rowPane.findPaneOfTypeByID("removePlayer", Button.class)).setEnabled(false);
                    ((Text)rowPane.findPaneOfTypeByID("rank", Text.class)).setText(rank.getName());
                    dropdown.setEnabled(false);
                } else {
                    dropdown.setDataProvider(new DropDownList.DataProvider(){

                        public int getElementCount() {
                            return WindowPermissionsPage.this.rankList.size();
                        }

                        public String getLabel(int i) {
                            Rank rank = WindowPermissionsPage.this.rankList.get(i);
                            return rank.getName();
                        }
                    });
                    dropdown.setSelectedIndex(WindowPermissionsPage.this.rankList.indexOf(rank));
                    dropdown.setHandler(WindowPermissionsPage.this::onRankSelected);
                }
            }
        });
    }

    private void onRankSelected(DropDownList dropdown) {
        int index = dropdown.getSelectedIndex();
        ColonyPlayer player = this.users.get(this.userList.getListElementIndexByPane((Pane)dropdown));
        Rank rank = this.rankList.get(index);
        if (rank != player.getRank()) {
            player.setRank(rank);
            Network.getNetwork().sendToServer(new PermissionsMessage.ChangePlayerRank(((ITownHallView)this.building).getColony(), player.getID(), rank));
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.updateUsers();
        this.updateRanks();
    }

    private void addPlayerCLicked() {
        TextField input = (TextField)this.findPaneOfTypeByID("addPlayerName", TextField.class);
        Network.getNetwork().sendToServer(new PermissionsMessage.AddPlayer(((ITownHallView)this.building).getColony(), input.getText()));
        input.setText("");
    }

    private void removePlayerClicked(Button button) {
        ColonyPlayer user;
        int row = this.userList.getListElementIndexByPane((Pane)button);
        if (row >= 0 && row < this.users.size() && (user = this.users.get(row)).getRank().getId() != 0) {
            this.users.remove(user);
            this.userList.removeChild((Pane)button.getParent());
            Network.getNetwork().sendToServer(new PermissionsMessage.RemovePlayer(((ITownHallView)this.building).getColony(), user.getID()));
        }
    }

    @Override
    protected String getWindowId() {
        return "permissions";
    }
}

