/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.util.Log;
import java.io.File;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public final class Utils {
    private static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();

    private Utils() {
    }

    public static boolean isBlockInRange(@NotNull Level world, Block block, int posX, int posY, int posZ, int range) {
        for (int x = posX - range; x < posX + range; ++x) {
            for (int z = posZ - range; z < posZ + range; ++z) {
                for (int y = posY - range; y < posY + range; ++y) {
                    if (!Objects.equals(world.m_8055_(new BlockPos(x, y, z)).m_60734_(), block)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean testFlag(long data, long flag) {
        return Utils.mask(data, flag) == flag;
    }

    public static long mask(long data, long mask) {
        return data & mask;
    }

    public static long setFlag(long data, long flag) {
        return data | flag;
    }

    public static long unsetFlag(long data, long flag) {
        return data & (flag ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long toggleFlag(long data, long flag) {
        return data ^ flag;
    }

    public static void checkDirectory(@NotNull File directory) {
        if (!directory.exists() && !directory.mkdirs()) {
            Log.getLogger().error("Directory doesn't exist and failed to be created: " + directory.toString());
        }
    }

    public static String format(long value) {
        if (value == Long.MIN_VALUE) {
            return Utils.format(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + Utils.format(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    static {
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "M");
        suffixes.put(1000000000L, "G");
        suffixes.put(1000000000000L, "T");
        suffixes.put(1000000000000000L, "P");
        suffixes.put(1000000000000000000L, "E");
    }
}

