/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.entity.pathfinding.WaterPathResult;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public final class Pond {
    private static final int WATER_POOL_WIDTH_REQUIREMENT = 6;
    private static final int WATER_POOL_LENGTH_REQUIREMENT = 2;

    public static boolean checkWater(@NotNull LevelReader world, @NotNull BlockPos water, WaterPathResult result) {
        if (Pond.checkWater(world, water, 6, 2)) {
            result.pond = water;
            return true;
        }
        return false;
    }

    public static boolean checkWater(@NotNull LevelReader world, @NotNull BlockPos water, int width, int length) {
        int z;
        int y;
        if (world.m_8055_(water).m_60734_() != Blocks.f_49990_ || !world.m_46859_(water.m_7494_())) {
            return false;
        }
        int x = water.m_123341_();
        return Pond.checkWaterPoolInDirectionXThenZ(world, x, y = water.m_123342_(), z = water.m_123343_(), 1, width, length) || Pond.checkWaterPoolInDirectionXThenZ(world, x, y, z, -1, width, length) || Pond.checkWaterPoolInDirectionZThenX(world, x, y, z, 1, width, length) || Pond.checkWaterPoolInDirectionZThenX(world, x, y, z, -1, width, length);
    }

    private static boolean checkWaterPoolInDirectionXThenZ(@NotNull LevelReader world, int x, int y, int z, int vector, int width, int length) {
        for (int dx = x + width * vector; dx <= x + width * vector; ++dx) {
            if (world.m_8055_(new BlockPos(dx, y, z)).m_60734_() == Blocks.f_49990_) continue;
            return false;
        }
        return Pond.checkWaterPoolInDirectionZ(world, x + length * vector, y, z, 1) && Pond.checkWaterPoolInDirectionZ(world, x + length * vector, y, z, -1);
    }

    private static boolean checkWaterPoolInDirectionZThenX(@NotNull LevelReader world, int x, int y, int z, int vector, int width, int length) {
        for (int dz = z + width * vector; dz <= z + width * vector; ++dz) {
            if (world.m_8055_(new BlockPos(x, y, dz)).m_60734_() == Blocks.f_49990_) continue;
            return false;
        }
        return Pond.checkWaterPoolInDirectionX(world, x, y, z + length * vector, 1) && Pond.checkWaterPoolInDirectionX(world, x, y, z + length * vector, -1);
    }

    private static boolean checkWaterPoolInDirectionZ(@NotNull LevelReader world, int x, int y, int z, int vector) {
        for (int dz = z + 2 * vector; dz <= z + 2 * vector; ++dz) {
            if (world.m_8055_(new BlockPos(x, y, dz)).m_60734_() == Blocks.f_49990_) continue;
            return false;
        }
        return true;
    }

    private static boolean checkWaterPoolInDirectionX(@NotNull LevelReader world, int x, int y, int z, int vector) {
        for (int dx = x + 2 * vector; dx <= x + 2 * vector; ++dx) {
            if (world.m_8055_(new BlockPos(dx, y, z)).m_60734_() == Blocks.f_49990_) continue;
            return false;
        }
        return true;
    }
}

