/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.tileentities;

import com.ldtteam.structurize.api.util.IRotatableBlockEntity;
import com.minecolonies.api.blocks.AbstractBlockMinecoloniesRack;
import com.minecolonies.api.blocks.types.RackType;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.inventory.api.CombinedItemHandler;
import com.minecolonies.api.inventory.container.ContainerRack;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityRack
extends AbstractTileEntityRack
implements IRotatableBlockEntity {
    private static final byte VERSION = 2;
    private byte version = 0;
    private final Map<ItemStorage, Integer> content = new HashMap<ItemStorage, Integer>();
    private int size = 0;
    private int freeSlots = 0;
    private LazyOptional<IItemHandler> lastOptional;

    public TileEntityRack(BlockEntityType<? extends TileEntityRack> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TileEntityRack(BlockEntityType<? extends TileEntityRack> type, BlockPos pos, BlockState state, int size) {
        super(type, pos, state, size);
        this.size = (size - 27) / 9;
    }

    public TileEntityRack(BlockPos pos, BlockState state) {
        super(MinecoloniesTileEntities.RACK, pos, state);
    }

    @Override
    public void setInWarehouse(Boolean isInWarehouse) {
        this.inWarehouse = isInWarehouse;
    }

    @Override
    public int getFreeSlots() {
        return this.freeSlots;
    }

    @Override
    public boolean hasItemStack(ItemStack stack, int count, boolean ignoreDamageValue) {
        ItemStorage checkItem = new ItemStorage(stack, ignoreDamageValue);
        return this.content.getOrDefault(checkItem, 0) >= count;
    }

    @Override
    public int getCount(ItemStack stack, boolean ignoreDamageValue, boolean ignoreNBT) {
        ItemStorage checkItem = new ItemStorage(stack, ignoreDamageValue, ignoreNBT);
        return this.getCount(checkItem);
    }

    @Override
    public int getCount(ItemStorage storage) {
        if (storage.ignoreDamageValue() || storage.ignoreNBT()) {
            if (!this.content.containsKey(storage)) {
                return 0;
            }
            int count = 0;
            for (Map.Entry<ItemStorage, Integer> contentStorage : this.content.entrySet()) {
                if (!contentStorage.getKey().equals(storage)) continue;
                count += contentStorage.getValue().intValue();
            }
            return count;
        }
        return this.content.getOrDefault(storage, 0);
    }

    @Override
    public boolean hasItemStack(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        for (Map.Entry<ItemStorage, Integer> entry : this.content.entrySet()) {
            if (!itemStackSelectionPredicate.test(entry.getKey().getItemStack())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSimilarStack(@NotNull ItemStack stack) {
        ItemStorage checkItem = new ItemStorage(stack, true, true);
        if (this.content.containsKey(checkItem)) {
            return true;
        }
        for (ItemStorage storage : this.content.keySet()) {
            if (checkItem.getPrimaryCreativeTabIndex() != storage.getPrimaryCreativeTabIndex()) continue;
            return true;
        }
        return false;
    }

    public Map<ItemStorage, Integer> getAllContent() {
        return this.content;
    }

    @Override
    public void upgradeRackSize() {
        ++this.size;
        AbstractTileEntityRack.RackInventory tempInventory = new AbstractTileEntityRack.RackInventory(27 + this.size * 9);
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            tempInventory.setStackInSlot(slot, this.inventory.getStackInSlot(slot));
        }
        this.inventory = tempInventory;
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        this.invalidateCap();
    }

    @Override
    public int getItemCount(Predicate<ItemStack> predicate) {
        int matched = 0;
        for (Map.Entry<ItemStorage, Integer> entry : this.content.entrySet()) {
            if (!predicate.test(entry.getKey().getItemStack())) continue;
            matched += entry.getValue().intValue();
        }
        return matched;
    }

    @Override
    public void updateItemStorage() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            boolean empty = this.content.isEmpty();
            this.updateContent();
            if (empty && !this.content.isEmpty() || !empty && this.content.isEmpty()) {
                this.updateBlockState();
            }
            this.m_6596_();
        }
    }

    private void updateContent() {
        this.content.clear();
        this.freeSlots = 0;
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) {
                ++this.freeSlots;
                continue;
            }
            ItemStorage storage = new ItemStorage(stack.m_41777_());
            int amount = ItemStackUtils.getSize(stack);
            if (this.content.containsKey(storage)) {
                amount += this.content.remove(storage).intValue();
            }
            this.content.put(storage, amount);
        }
    }

    @Override
    public void updateBlockState() {
        if (this.f_58857_ != null && this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof AbstractBlockMinecoloniesRack) {
            if (!(this.main || this.single || this.getOtherChest() == null || this.getOtherChest().isMain())) {
                this.setMain(true);
            }
            if (this.main || this.single) {
                BlockState typeNeighbor;
                BlockState typeHere;
                if (this.content.isEmpty() && (this.getOtherChest() == null || this.getOtherChest().isEmpty())) {
                    if (this.getOtherChest() != null && this.f_58857_.m_8055_(this.f_58858_.m_141950_((Vec3i)this.relativeNeighbor)).m_60734_() instanceof AbstractBlockMinecoloniesRack) {
                        Direction dirToNeighbour = BlockPosUtil.getFacing(this.f_58858_, this.f_58858_.m_141950_((Vec3i)this.relativeNeighbor));
                        typeHere = (BlockState)((BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.EMPTYAIR))).m_61124_((Property)AbstractBlockMinecoloniesRack.FACING, (Comparable)dirToNeighbour);
                        typeNeighbor = (BlockState)((BlockState)this.f_58857_.m_8055_(this.f_58858_.m_141950_((Vec3i)this.relativeNeighbor)).m_61124_(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.DEFAULTDOUBLE))).m_61124_((Property)AbstractBlockMinecoloniesRack.FACING, (Comparable)dirToNeighbour.m_122424_());
                    } else {
                        typeHere = (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.DEFAULT));
                        typeNeighbor = null;
                    }
                } else if (this.getOtherChest() != null && this.f_58857_.m_8055_(this.f_58858_.m_141950_((Vec3i)this.relativeNeighbor)).m_60734_() instanceof AbstractBlockMinecoloniesRack) {
                    Direction dirToNeighbour = BlockPosUtil.getFacing(this.f_58858_, this.f_58858_.m_141950_((Vec3i)this.relativeNeighbor));
                    typeHere = (BlockState)((BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.EMPTYAIR))).m_61124_((Property)AbstractBlockMinecoloniesRack.FACING, (Comparable)dirToNeighbour);
                    typeNeighbor = (BlockState)((BlockState)this.f_58857_.m_8055_(this.f_58858_.m_141950_((Vec3i)this.relativeNeighbor)).m_61124_(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.FULLDOUBLE))).m_61124_((Property)AbstractBlockMinecoloniesRack.FACING, (Comparable)dirToNeighbour.m_122424_());
                } else {
                    typeHere = (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.FULL));
                    typeNeighbor = null;
                }
                if (this.isMain() && this.getOtherChest() != null && this.getOtherChest().isMain()) {
                    this.getOtherChest().setMain(false);
                }
                if (!this.f_58857_.m_8055_(this.f_58858_).equals(typeHere)) {
                    this.f_58857_.m_46597_(this.f_58858_, typeHere);
                }
                if (typeNeighbor != null && !this.f_58857_.m_8055_(this.f_58858_.m_141950_((Vec3i)this.relativeNeighbor)).equals(typeNeighbor)) {
                    this.f_58857_.m_46597_(this.f_58858_.m_141950_((Vec3i)this.relativeNeighbor), typeNeighbor);
                }
            } else {
                this.getOtherChest().updateBlockState();
            }
        }
    }

    @Override
    public AbstractTileEntityRack getOtherChest() {
        if (this.relativeNeighbor == null || this.f_58857_ == null) {
            return null;
        }
        BlockEntity tileEntity = this.f_58857_.m_7702_(this.f_58858_.m_141950_((Vec3i)this.relativeNeighbor));
        if (tileEntity instanceof TileEntityRack && !(tileEntity instanceof AbstractTileEntityColonyBuilding)) {
            if (!this.m_58899_().equals((Object)((TileEntityRack)tileEntity).getNeighbor())) {
                ((AbstractTileEntityRack)tileEntity).setNeighbor(this.m_58899_());
            }
            return (AbstractTileEntityRack)tileEntity;
        }
        this.setSingle(true);
        this.relativeNeighbor = null;
        return null;
    }

    @Override
    public ItemStackHandler createInventory(int slots) {
        return new AbstractTileEntityRack.RackInventory(slots);
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128431_().contains("tagSIze")) {
            this.size = compound.m_128451_("tagSIze");
            this.inventory = this.createInventory(27 + this.size * 9);
        }
        if (compound.m_128431_().contains("relNeighbor")) {
            this.relativeNeighbor = BlockPosUtil.read(compound, "relNeighbor");
        }
        if (this.relativeNeighbor != null) {
            if (this.relativeNeighbor.m_123342_() != 0) {
                this.relativeNeighbor = null;
            } else {
                this.setSingle(false);
            }
        }
        ListTag inventoryTagList = compound.m_128437_("inventory", 10);
        for (int i = 0; i < inventoryTagList.size(); ++i) {
            CompoundTag inventoryCompound = inventoryTagList.m_128728_(i);
            if (inventoryCompound.m_128441_("empty")) continue;
            ItemStack stack = ItemStack.m_41712_((CompoundTag)inventoryCompound);
            this.inventory.setStackInSlot(i, stack);
        }
        this.main = compound.m_128471_("main");
        this.updateContent();
        this.inWarehouse = compound.m_128471_("inWarehouse");
        if (compound.m_128441_("pos")) {
            this.buildingPos = BlockPosUtil.read(compound, "pos");
        }
        this.version = compound.m_128445_("version");
        this.invalidateCap();
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("tagSIze", this.size);
        if (this.relativeNeighbor != null) {
            BlockPosUtil.write(compound, "relNeighbor", this.relativeNeighbor);
        }
        @NotNull ListTag inventoryTagList = new ListTag();
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            @NotNull CompoundTag inventoryCompound = new CompoundTag();
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.m_41619_()) {
                inventoryCompound.m_128379_("empty", true);
            } else {
                stack.m_41739_(inventoryCompound);
            }
            inventoryTagList.add((Object)inventoryCompound);
        }
        compound.m_128365_("inventory", (Tag)inventoryTagList);
        compound.m_128379_("main", this.main);
        compound.m_128379_("inWarehouse", this.inWarehouse);
        BlockPosUtil.write(compound, "pos", this.buildingPos);
        compound.m_128344_("version", this.version);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void rotate(Rotation rotationIn) {
        if (this.relativeNeighbor != null) {
            this.relativeNeighbor = this.relativeNeighbor.m_7954_(rotationIn);
        }
    }

    public void mirror(Mirror mirror) {
        if (this.relativeNeighbor != null) {
            switch (mirror) {
                case LEFT_RIGHT: {
                    this.relativeNeighbor = new BlockPos(this.relativeNeighbor.m_123341_(), this.relativeNeighbor.m_123342_(), -this.relativeNeighbor.m_123343_());
                    break;
                }
                case FRONT_BACK: {
                    this.relativeNeighbor = new BlockPos(-this.relativeNeighbor.m_123341_(), this.relativeNeighbor.m_123342_(), this.relativeNeighbor.m_123343_());
                }
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction dir) {
        if (this.version != 2) {
            this.updateBlockState();
            this.version = (byte)2;
        }
        if (!this.f_58859_ && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.lastOptional != null && this.lastOptional.isPresent()) {
                return this.lastOptional.cast();
            }
            if (this.single) {
                this.lastOptional = LazyOptional.of(() -> {
                    if (this.m_58901_()) {
                        return new AbstractTileEntityRack.RackInventory(0);
                    }
                    return new CombinedItemHandler("block.minecolonies.blockminecoloniesrack", this.getInventory());
                });
                return this.lastOptional.cast();
            }
            this.lastOptional = LazyOptional.of(() -> {
                if (this.m_58901_()) {
                    return new AbstractTileEntityRack.RackInventory(0);
                }
                AbstractTileEntityRack other = this.getOtherChest();
                if (other == null) {
                    return new CombinedItemHandler("block.minecolonies.blockminecoloniesrack", this.getInventory());
                }
                if (this.main) {
                    return new CombinedItemHandler("block.minecolonies.blockminecoloniesrack", this.getInventory(), other.getInventory());
                }
                return new CombinedItemHandler("block.minecolonies.blockminecoloniesrack", other.getInventory(), this.getInventory());
            });
            return this.lastOptional.cast();
        }
        return super.getCapability(capability, dir);
    }

    @Override
    public BlockPos getNeighbor() {
        if (this.relativeNeighbor == null) {
            return null;
        }
        return this.f_58858_.m_141950_((Vec3i)this.relativeNeighbor);
    }

    @Override
    public int getUpgradeSize() {
        return this.size;
    }

    @Override
    public boolean setNeighbor(BlockPos neighbor) {
        if (neighbor == null) {
            this.setSingle(true);
            this.relativeNeighbor = null;
            this.m_6596_();
        } else if (this.f_58858_.m_141950_((Vec3i)neighbor).m_123342_() == 0) {
            this.relativeNeighbor = this.f_58858_.m_141950_((Vec3i)neighbor);
            this.setSingle(false);
            this.m_6596_();
            return true;
        }
        return false;
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            WorldUtil.markChunkDirty(this.f_58857_, this.f_58858_);
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new ContainerRack(id, inv, this.m_58899_(), this.getOtherChest() == null ? BlockPos.f_121853_ : this.getOtherChest().m_58899_());
    }

    @NotNull
    public Component m_5446_() {
        return new TextComponent("Rack");
    }

    @Override
    public void setMain(boolean main) {
        if (main != this.main) {
            this.invalidateCap();
            super.setMain(main);
        }
    }

    @Override
    public void setSingle(boolean single) {
        if (single != this.single) {
            this.invalidateCap();
            super.setSingle(single);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.invalidateCap();
    }

    private void invalidateCap() {
        if (this.lastOptional != null && this.lastOptional.isPresent()) {
            this.lastOptional.invalidate();
        }
        this.lastOptional = null;
    }

    public boolean isSingle() {
        return this.single;
    }
}

