/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.tileentities;

import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.InventoryFunctions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTileEntityColonyBuilding
extends TileEntityRack
implements IBlueprintDataProvider {
    private static final String TAG_VERSION = "version";
    private static final int VERSION = 2;
    private BlockPos corner1 = BlockPos.f_121853_;
    private BlockPos corner2 = BlockPos.f_121853_;
    private String schematicName = "";
    private Map<BlockPos, List<String>> tagPosMap = new HashMap<BlockPos, List<String>>();
    private int version = 0;

    public AbstractTileEntityColonyBuilding(BlockEntityType<? extends AbstractTileEntityColonyBuilding> type, BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends TileEntityRack>)type, pos, state);
    }

    public static boolean isInTileEntity(ICapabilityProvider entity, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryFunctions.matchFirstInProvider(entity, itemStackSelectionPredicate);
    }

    public abstract int getColonyId();

    public abstract IColony getColony();

    public abstract void setColony(IColony var1);

    public abstract BlockPos getPosition();

    @Nullable
    public abstract BlockPos getPositionOfChestWithItemStack(@NotNull Predicate<ItemStack> var1);

    public abstract IBuilding getBuilding();

    public abstract void setBuilding(IBuilding var1);

    public abstract IBuildingView getBuildingView();

    public abstract boolean hasAccessPermission(Player var1);

    public abstract void setMirror(boolean var1);

    public abstract boolean isMirrored();

    public abstract String getStyle();

    public abstract void setStyle(String var1);

    public abstract ResourceLocation getBuildingName();

    public String getSchematicName() {
        return this.schematicName;
    }

    public void setSchematicName(String name) {
        this.schematicName = name;
    }

    public Map<BlockPos, List<String>> getPositionedTags() {
        return this.tagPosMap;
    }

    public void setPositionedTags(Map<BlockPos, List<String>> positionedTags) {
        this.tagPosMap = positionedTags;
        this.m_6596_();
    }

    public Tuple<BlockPos, BlockPos> getSchematicCorners() {
        return new Tuple((Object)this.corner1, (Object)this.corner2);
    }

    public void setSchematicCorners(BlockPos pos1, BlockPos pos2) {
        this.corner1 = pos1;
        this.corner2 = pos2;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.readSchematicDataFromNBT(compound);
        this.version = compound.m_128451_(TAG_VERSION);
    }

    public void readSchematicDataFromNBT(CompoundTag originalCompound) {
        String old = this.getSchematicName();
        super.readSchematicDataFromNBT(originalCompound);
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || this.getColony() == null || this.getColony().getBuildingManager() == null) {
            return;
        }
        IBuilding building = this.getColony().getBuildingManager().getBuilding(this.f_58858_);
        if (building != null) {
            building.onUpgradeSchematicTo(old, this.getSchematicName(), this);
        }
        this.version = 2;
    }

    @Override
    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        this.writeSchematicDataToNBT(compound);
        compound.m_128405_(TAG_VERSION, this.version);
    }

    public BlockPos getTilePos() {
        return this.f_58858_;
    }

    public boolean isOutdated() {
        return this.version < 2;
    }
}

