/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.sounds;

import com.minecolonies.api.colony.jobs.registry.IJobRegistry;
import com.minecolonies.api.entity.mobs.RaiderType;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.sounds.MercenarySounds;
import com.minecolonies.api.sounds.RaidSounds;
import com.minecolonies.api.sounds.RaiderSounds;
import com.minecolonies.api.sounds.TavernSounds;
import com.minecolonies.api.util.Tuple;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ModSoundEvents {
    public static Map<String, Map<EventType, Tuple<SoundEvent, SoundEvent>>> CITIZEN_SOUND_EVENTS = new HashMap<String, Map<EventType, Tuple<SoundEvent, SoundEvent>>>();
    public static SoundEvent SAW;

    private ModSoundEvents() {
    }

    public static void registerSounds(IForgeRegistry<SoundEvent> registry) {
        for (EventType[] job : IJobRegistry.getInstance().getValues()) {
            if (!job.getRegistryName().m_135827_().equals("minecolonies") || job.getRegistryName().m_135815_().equals("placeholder")) continue;
            HashMap<EventType, Tuple<SoundEvent, SoundEvent>> map = new HashMap<EventType, Tuple<SoundEvent, SoundEvent>>();
            for (EventType soundEvents : EventType.values()) {
                SoundEvent maleSoundEvent = ModSoundEvents.getSoundID("mob." + job.getRegistryName().m_135815_() + ".male." + soundEvents.name().toLowerCase(Locale.US));
                SoundEvent femaleSoundEvent = ModSoundEvents.getSoundID("mob." + job.getRegistryName().m_135815_() + ".female." + soundEvents.name().toLowerCase(Locale.US));
                registry.register((IForgeRegistryEntry)maleSoundEvent);
                registry.register((IForgeRegistryEntry)femaleSoundEvent);
                map.put(soundEvents, new Tuple<SoundEvent, SoundEvent>(maleSoundEvent, femaleSoundEvent));
            }
            CITIZEN_SOUND_EVENTS.put(job.getRegistryName().m_135815_(), map);
        }
        HashMap<EventType, Tuple<SoundEvent, SoundEvent>> citizenMap = new HashMap<EventType, Tuple<SoundEvent, SoundEvent>>();
        for (EventType soundEvents : EventType.values()) {
            SoundEvent soundEvent = ModSoundEvents.getSoundID("mob.citizen.male." + soundEvents.name().toLowerCase(Locale.US));
            SoundEvent femaleSoundEvent = ModSoundEvents.getSoundID("mob.citizen.female." + soundEvents.name().toLowerCase(Locale.US));
            registry.register((IForgeRegistryEntry)soundEvent);
            registry.register((IForgeRegistryEntry)femaleSoundEvent);
            citizenMap.put(soundEvents, new Tuple<SoundEvent, SoundEvent>(soundEvent, femaleSoundEvent));
        }
        CITIZEN_SOUND_EVENTS.put("citizen", citizenMap);
        HashMap<EventType, Tuple<SoundEvent, SoundEvent>> childMap = new HashMap<EventType, Tuple<SoundEvent, SoundEvent>>();
        for (EventType eventType : EventType.values()) {
            SoundEvent maleSoundEvent = ModSoundEvents.getSoundID("mob.child.male." + eventType.name().toLowerCase(Locale.US));
            SoundEvent femaleSoundEvent = ModSoundEvents.getSoundID("mob.child.female." + eventType.name().toLowerCase(Locale.US));
            registry.register((IForgeRegistryEntry)maleSoundEvent);
            registry.register((IForgeRegistryEntry)femaleSoundEvent);
            childMap.put(eventType, new Tuple<SoundEvent, SoundEvent>(maleSoundEvent, femaleSoundEvent));
        }
        CITIZEN_SOUND_EVENTS.put("child", childMap);
        registry.register((IForgeRegistryEntry)TavernSounds.tavernTheme);
        for (Enum enum_ : RaiderType.values()) {
            SoundEvent raiderHurt = ModSoundEvents.getSoundID("mob." + enum_.name().toLowerCase(Locale.US) + ".hurt");
            SoundEvent raiderDeath = ModSoundEvents.getSoundID("mob." + enum_.name().toLowerCase(Locale.US) + ".death");
            SoundEvent raiderSay = ModSoundEvents.getSoundID("mob." + enum_.name().toLowerCase(Locale.US) + ".say");
            registry.register((IForgeRegistryEntry)raiderHurt);
            registry.register((IForgeRegistryEntry)raiderDeath);
            registry.register((IForgeRegistryEntry)raiderSay);
            HashMap<RaiderSounds.RaiderSoundTypes, SoundEvent> sounds = new HashMap<RaiderSounds.RaiderSoundTypes, SoundEvent>();
            sounds.put(RaiderSounds.RaiderSoundTypes.HURT, raiderHurt);
            sounds.put(RaiderSounds.RaiderSoundTypes.DEATH, raiderDeath);
            sounds.put(RaiderSounds.RaiderSoundTypes.SAY, raiderSay);
            RaiderSounds.raiderSounds.put((RaiderType)enum_, sounds);
        }
        SAW = ModSoundEvents.getSoundID("tile.sawmill.saw");
        registry.register((IForgeRegistryEntry)SAW);
        registry.register((IForgeRegistryEntry)RaidSounds.WARNING);
        registry.register((IForgeRegistryEntry)RaidSounds.WARNING_EARLY);
        registry.register((IForgeRegistryEntry)RaidSounds.VICTORY);
        registry.register((IForgeRegistryEntry)RaidSounds.VICTORY_EARLY);
        registry.register((IForgeRegistryEntry)RaidSounds.AMAZON_RAID);
        registry.register((IForgeRegistryEntry)RaidSounds.DESERT_RAID);
        registry.register((IForgeRegistryEntry)RaidSounds.DESERT_RAID_WARNING);
        registry.register((IForgeRegistryEntry)MercenarySounds.mercenaryAttack);
        registry.register((IForgeRegistryEntry)MercenarySounds.mercenaryCelebrate);
        registry.register((IForgeRegistryEntry)MercenarySounds.mercenaryDie);
        registry.register((IForgeRegistryEntry)MercenarySounds.mercenaryHurt);
        registry.register((IForgeRegistryEntry)MercenarySounds.mercenarySay);
        registry.register((IForgeRegistryEntry)MercenarySounds.mercenaryStep);
    }

    public static SoundEvent getSoundID(String soundName) {
        return (SoundEvent)new SoundEvent(new ResourceLocation("minecolonies", soundName)).setRegistryName(soundName);
    }
}

