/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.loot.ModLootConditions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public class ResearchUnlocked
implements LootItemCondition {
    private final ResourceLocation effectId;

    private ResearchUnlocked(@NotNull ResourceLocation effectId) {
        this.effectId = effectId;
    }

    public static LootItemCondition.Builder effect(@NotNull ResourceLocation effectId) {
        return () -> new ResearchUnlocked(effectId);
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return ModLootConditions.researchUnlocked;
    }

    public boolean test(@NotNull LootContext lootContext) {
        AbstractEntityCitizen citizen;
        IColony colony;
        Entity entity = (Entity)lootContext.m_78953_(LootContextParams.f_81458_);
        if (entity instanceof AbstractEntityCitizen && (colony = (citizen = (AbstractEntityCitizen)entity).getCitizenColonyHandler().getColony()) != null) {
            return colony.getResearchManager().getResearchEffects().getEffectStrength(this.effectId) > 0.0;
        }
        return false;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<ResearchUnlocked> {
        public void serialize(@NotNull JsonObject json, @NotNull ResearchUnlocked condition, @NotNull JsonSerializationContext context) {
            json.addProperty("id", condition.effectId.toString());
        }

        @NotNull
        public ResearchUnlocked deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext context) {
            ResourceLocation researchId = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"id", (String)""));
            return new ResearchUnlocked(researchId);
        }
    }
}

