/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility.tinkers;

import com.minecolonies.api.compatibility.tinkers.TinkersToolProxy;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public final class TinkersToolHelper
extends TinkersToolProxy {
    public static boolean isTinkersSword(@NotNull ItemStack stack) {
        return new TinkersToolHelper().isTinkersWeapon(stack);
    }

    @Override
    public boolean isTinkersWeapon(@NotNull ItemStack stack) {
        return ItemStackUtils.isEmpty(stack) == false && stack.m_204117_(TinkerTags.Items.SWORD);
    }

    @Override
    public double getAttackDamage(@NotNull ItemStack stack) {
        return ((Float)ToolStack.from((ItemStack)stack).getStats().get((IToolStat)ToolStats.ATTACK_DAMAGE)).floatValue();
    }

    @Override
    public int getToolLevel(@NotNull ItemStack stack) {
        if (this.checkTinkersBroken(stack)) {
            return -1;
        }
        return ((Tier)ToolStack.from((ItemStack)stack).getStats().get((IToolStat)ToolStats.HARVEST_TIER)).m_6604_();
    }

    public static double getDamage(@NotNull ItemStack stack) {
        return new TinkersToolHelper().getAttackDamage(stack);
    }

    public static int getToolLvl(@NotNull ItemStack stack) {
        return new TinkersToolHelper().getToolLevel(stack);
    }

    @Override
    public boolean checkTinkersBroken(@Nullable ItemStack stack) {
        return ItemStackUtils.isEmpty(stack) == false && ToolDamageUtil.isBroken((ItemStack)stack);
    }

    @Override
    public boolean isTinkersTool(@Nullable ItemStack stack, IToolType toolType) {
        if (ItemStackUtils.isEmpty(stack).booleanValue() || !(stack.m_41720_() instanceof ModifiableItem)) {
            return false;
        }
        if (ToolType.AXE.equals(toolType) && stack.canPerformAction(ToolActions.AXE_DIG)) {
            return true;
        }
        if (ToolType.SHOVEL.equals(toolType) && stack.canPerformAction(ToolActions.SHOVEL_DIG)) {
            return true;
        }
        if (ToolType.PICKAXE.equals(toolType) && stack.canPerformAction(ToolActions.PICKAXE_DIG)) {
            return true;
        }
        if (ToolType.HOE.equals(toolType)) {
            return stack.canPerformAction(ToolActions.HOE_DIG);
        }
        return stack.m_204117_(TinkerTags.Items.HARVEST);
    }
}

