/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility.dynamictrees;

import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.minecolonies.api.compatibility.dynamictrees.DynamicTreeProxy;
import com.minecolonies.api.util.Log;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public final class DynamicTreeCompat
extends DynamicTreeProxy {
    private static DynamicTreeCompat instance = new DynamicTreeCompat();
    private static final String DYNAMIC_TREE_DAMAGE = "fallingtree";
    private static final Map<ResourceKey<Level>, FakePlayer> fakePlayers = new HashMap<ResourceKey<Level>, FakePlayer>();

    @Override
    public boolean isDynamicTreePresent() {
        return true;
    }

    public static boolean isDynTreePresent() {
        return instance.isDynamicTreePresent();
    }

    @Override
    public boolean checkForDynamicTreeBlock(@NotNull Block block) {
        return block instanceof BranchBlock;
    }

    public static boolean isDynamicTreeBlock(Block block) {
        return instance.checkForDynamicTreeBlock(block);
    }

    @Override
    public boolean checkForDynamicLeavesBlock(Block block) {
        return block instanceof DynamicLeavesBlock;
    }

    public static boolean isDynamicLeavesBlock(Block block) {
        return instance.checkForDynamicLeavesBlock(block);
    }

    @Override
    public boolean checkForDynamicTrunkShellBlock(Block block) {
        return block instanceof TrunkShellBlock;
    }

    public static boolean isDynamicTrunkShellBlock(Block block) {
        return instance.checkForDynamicTrunkShellBlock(block);
    }

    @Override
    public NonNullList<ItemStack> getDropsForLeaf(LevelAccessor world, BlockPos pos, BlockState blockState, int fortune, Block leaf) {
        if (DynamicTreeCompat.isDynamicLeavesBlock(leaf)) {
            ItemStack stack = ((DynamicLeavesBlock)leaf).getFamily(blockState, (BlockGetter)world, pos).getCommonSpecies().getSeedStack(1);
            NonNullList list = NonNullList.m_122779_();
            list.add((Object)stack);
            return list;
        }
        return NonNullList.m_122779_();
    }

    public static NonNullList<ItemStack> getDropsForLeafCompat(LevelAccessor world, BlockPos pos, BlockState blockState, int fortune, Block leaf) {
        return instance.getDropsForLeaf(world, pos, blockState, fortune, leaf);
    }

    @Override
    public boolean checkForDynamicSapling(@NotNull Item item) {
        return item instanceof Seed;
    }

    public static boolean isDynamicTreeSapling(Item item) {
        return instance.checkForDynamicSapling(item);
    }

    public static boolean isDynamicTreeSapling(ItemStack stack) {
        return instance.checkForDynamicSapling(stack.m_41720_());
    }

    @Override
    public Runnable getTreeBreakActionCompat(@NotNull Level world, @NotNull BlockPos blockToBreak, ItemStack toolToUse, BlockPos workerPos) {
        return () -> {
            BlockState curBlockState = world.m_8055_(blockToBreak);
            Block curBlock = curBlockState.m_60734_();
            if (world.m_142572_() == null) {
                Log.getLogger().error("Minecolonies:DynamicTreeCompat unexpected null while trying to get World");
                return;
            }
            ResourceKey dim = world.m_46472_();
            FakePlayer fake = fakePlayers.get(dim);
            if (fake == null) {
                fakePlayers.put((ResourceKey<Level>)dim, new FakePlayer((ServerLevel)world, new GameProfile(UUID.randomUUID(), "minecolonies_LumberjackFake")));
                fake = fakePlayers.get(dim);
            }
            if (workerPos != null) {
                fake.m_6034_((double)workerPos.m_123341_(), (double)workerPos.m_123342_(), (double)workerPos.m_123343_());
            }
            if (toolToUse != null) {
                fake.m_21008_(InteractionHand.MAIN_HAND, toolToUse);
            }
            FluidState fluidState = world.m_6425_(blockToBreak);
            curBlock.onDestroyedByPlayer(curBlockState, world, blockToBreak, (Player)fake, true, fluidState);
        };
    }

    public static Runnable getTreeBreakAction(Level world, BlockPos blockToBreak, ItemStack toolToUse, BlockPos workerPos) {
        return instance.getTreeBreakActionCompat(world, blockToBreak, toolToUse, workerPos);
    }

    @Override
    public boolean plantDynamicSaplingCompat(@NotNull Level world, @NotNull BlockPos location, @NotNull ItemStack saplingStack) {
        if (saplingStack.m_41720_() instanceof Seed) {
            return ((Seed)saplingStack.m_41720_()).getSpecies().plantSapling((LevelAccessor)world, location, false);
        }
        return false;
    }

    public static boolean plantDynamicSapling(Level world, BlockPos location, ItemStack sapling) {
        return instance.plantDynamicSaplingCompat(world, location, sapling);
    }

    @Override
    public String getDynamicTreeDamage() {
        return DYNAMIC_TREE_DAMAGE;
    }

    @Override
    public boolean hasFittingTreeFamilyCompat(@NotNull BlockPos block1, @NotNull BlockPos block2, @NotNull LevelAccessor world) {
        Family fam1 = DynamicTreeCompat.getFamilyForBlock(block1, world);
        Family fam2 = DynamicTreeCompat.getFamilyForBlock(block2, world);
        if (fam1 != null && fam2 != null) {
            return fam1 == fam2;
        }
        return false;
    }

    private static Family getFamilyForBlock(@NotNull BlockPos blockPos, @NotNull LevelAccessor world) {
        Block block = world.m_8055_(blockPos).m_60734_();
        if (block instanceof BranchBlock) {
            return ((BranchBlock)block).getFamily();
        }
        if (block instanceof DynamicLeavesBlock) {
            return ((DynamicLeavesBlock)block).getFamily(world.m_8055_(blockPos), (BlockGetter)world, blockPos);
        }
        return null;
    }

    public static boolean hasFittingTreeFamily(@NotNull BlockPos block1, @NotNull BlockPos block2, @NotNull LevelAccessor world) {
        return instance.hasFittingTreeFamilyCompat(block1, block2, world);
    }
}

