/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony;

import com.minecolonies.api.util.ChunkLoadStorage;
import com.minecolonies.api.util.NBTUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public interface IChunkmanagerCapability {
    @Nullable
    public ChunkLoadStorage getChunkStorage(int var1, int var2);

    public boolean addChunkStorage(int var1, int var2, ChunkLoadStorage var3);

    public Map<ChunkPos, ChunkLoadStorage> getAllChunkStorages();

    public static class Storage {
        public static Tag writeNBT(@NotNull Capability<IChunkmanagerCapability> capability, @NotNull IChunkmanagerCapability instance, @Nullable Direction side) {
            CompoundTag compound = new CompoundTag();
            compound.m_128365_("allchunk", (Tag)instance.getAllChunkStorages().entrySet().stream().map(entry -> Storage.write((ChunkPos)entry.getKey(), (ChunkLoadStorage)entry.getValue())).collect(NBTUtils.toListNBT()));
            return compound;
        }

        public static void readNBT(@NotNull Capability<IChunkmanagerCapability> capability, @NotNull IChunkmanagerCapability instance, @Nullable Direction side, @NotNull Tag nbt) {
            if (nbt instanceof CompoundTag && ((CompoundTag)nbt).m_128431_().contains("allchunk")) {
                NBTUtils.streamCompound(((CompoundTag)nbt).m_128437_("allchunk", 10)).map(Storage::read).forEach(key -> instance.addChunkStorage(((ChunkPos)key.m_14418_()).f_45578_, ((ChunkPos)key.m_14418_()).f_45579_, (ChunkLoadStorage)key.m_14419_()));
            }
        }

        private static CompoundTag write(ChunkPos key, ChunkLoadStorage value) {
            CompoundTag compound = new CompoundTag();
            compound.m_128365_("chunk", (Tag)value.toNBT());
            compound.m_128405_("xPos", key.f_45578_);
            compound.m_128405_("zPos", key.f_45579_);
            return compound;
        }

        private static Tuple<ChunkPos, ChunkLoadStorage> read(CompoundTag compound) {
            ChunkLoadStorage storage = new ChunkLoadStorage(compound.m_128469_("chunk"));
            int x = compound.m_128451_("xPos");
            int z = compound.m_128451_("zPos");
            return new Tuple((Object)new ChunkPos(x, z), (Object)storage);
        }
    }

    public static class Impl
    implements IChunkmanagerCapability {
        private final Map<ChunkPos, ChunkLoadStorage> chunkStorages = new HashMap<ChunkPos, ChunkLoadStorage>();

        @Override
        @Nullable
        public ChunkLoadStorage getChunkStorage(int chunkX, int chunkZ) {
            return this.chunkStorages.remove(new ChunkPos(chunkX, chunkZ));
        }

        @Override
        public boolean addChunkStorage(int chunkX, int chunkZ, ChunkLoadStorage storage) {
            ChunkLoadStorage existingStorage = this.chunkStorages.get(new ChunkPos(chunkX, chunkZ));
            if (existingStorage == null) {
                this.chunkStorages.put(new ChunkPos(chunkX, chunkZ), storage);
                return false;
            }
            existingStorage.merge(storage);
            return true;
        }

        @Override
        public Map<ChunkPos, ChunkLoadStorage> getAllChunkStorages() {
            return this.chunkStorages;
        }
    }
}

