/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.blocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbuilder.compat.RFToolsBuilderTOPDriver;
import mcjty.rftoolsbuilder.modules.mover.MoverConfiguration;
import mcjty.rftoolsbuilder.modules.mover.MoverModule;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverTileEntity;
import mcjty.rftoolsbuilder.modules.mover.client.GuiMoverController;
import mcjty.rftoolsbuilder.modules.mover.items.VehicleCard;
import mcjty.rftoolsbuilder.modules.mover.logic.MoverGraphNode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;

public class MoverControllerTileEntity
extends GenericTileEntity {
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)MoverConfiguration.MAXENERGY.get()).intValue(), (long)((Integer)MoverConfiguration.RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Mover").containerSupplier(DefaultContainerProvider.empty(MoverModule.CONTAINER_MOVER_CONTROLLER, (GenericTileEntity)this)).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final IInfusable infusable = new DefaultInfusable((BlockEntity)this);
    public static final int MAXSCAN = 512;
    private final Map<BlockPos, MoverGraphNode> nodes = new HashMap<BlockPos, MoverGraphNode>();
    private MoverGraphNode graph;
    @GuiValue
    public static final Value<?, String> VALUE_SELECTED_VEHICLE = Value.create((String)"selectedVehicle", (Type)Type.STRING, MoverControllerTileEntity::getSelectedVehicle, MoverControllerTileEntity::setSelectedVehicle);
    private String selectedVehicle;
    public static final Key<BlockPos> SELECTED_NODE = new Key("node", Type.BLOCKPOS);
    public static final Key<String> SELECTED_VEHICLE = new Key("vehicle", Type.STRING);
    @ServerCommand
    public static final Command<?> CMD_SCAN = Command.create((String)"scan", (te, player, params) -> te.doScan());
    @ServerCommand
    public static final Command<?> CMD_MOVE = Command.create((String)"move", (te, player, params) -> te.doMove((BlockPos)params.get(SELECTED_NODE), (String)params.get(SELECTED_VEHICLE)));
    @ServerCommand
    public static final Command<?> CMD_SELECTNODE = Command.create((String)"selectNode", (te, player, params) -> te.selectNode((BlockPos)params.get(SELECTED_NODE)));
    @ServerCommand(type=String.class)
    public static final ListCommand<?, ?> CMD_GETVEHICLES = ListCommand.create((String)"rftoolsbuilder.movercontroller.getVehicles", (te, player, params) -> te.getVehicles(), (te, player, params, list) -> GuiMoverController.setVehiclesFromServer(list));
    @ServerCommand(type=Pair.class, serializer=NodePairSerializer.class)
    public static final ListCommand<?, ?> CMD_GETNODES = ListCommand.create((String)"rftoolsbuilder.movercontroller.getNodes", (te, player, params) -> te.getNodes(), (te, player, params, list) -> GuiMoverController.setNodesFromServer(list));

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(MoverControllerTileEntity::new).topDriver((TOPDriver)RFToolsBuilderTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolsbuilder:todo")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}));
    }

    public MoverControllerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MoverModule.TYPE_MOVER_CONTROLLER.get(), pos, state);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        if (this.graph == null) {
            this.graph = new MoverGraphNode(this.f_58858_);
        }
        this.nodes.clear();
        ListTag graphTag = tagCompound.m_128437_("graph", 10);
        for (Tag tag : graphTag) {
            CompoundTag nodeTag = (CompoundTag)tag;
            BlockPos pos = new BlockPos(nodeTag.m_128451_("x"), nodeTag.m_128451_("y"), nodeTag.m_128451_("z"));
            MoverGraphNode childNode = new MoverGraphNode(pos);
            this.nodes.put(pos, childNode);
            CompoundTag childrenTag = nodeTag.m_128469_("c");
            for (Direction direction : OrientationTools.DIRECTION_VALUES) {
                if (!childrenTag.m_128441_(direction.name())) continue;
                CompoundTag childTag = childrenTag.m_128469_(direction.name());
                BlockPos childpos = new BlockPos(childTag.m_128451_("x"), childTag.m_128451_("y"), childTag.m_128451_("z"));
                childNode.add(direction, childpos);
            }
        }
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        ListTag graphTag = new ListTag();
        this.nodes.forEach((pos, node) -> {
            CompoundTag nodeTag = new CompoundTag();
            nodeTag.m_128405_("x", pos.m_123341_());
            nodeTag.m_128405_("y", pos.m_123342_());
            nodeTag.m_128405_("z", pos.m_123343_());
            CompoundTag childrenTag = new CompoundTag();
            node.getChildren().forEach((direction, childpos) -> {
                CompoundTag childTag = new CompoundTag();
                childTag.m_128405_("x", childpos.m_123341_());
                childTag.m_128405_("y", childpos.m_123342_());
                childTag.m_128405_("z", childpos.m_123343_());
                childrenTag.m_128365_(direction.name(), (Tag)childTag);
            });
            nodeTag.m_128365_("c", (Tag)childrenTag);
            graphTag.add((Object)nodeTag);
        });
        tagCompound.m_128365_("graph", (Tag)graphTag);
    }

    private void selectNode(BlockPos pos) {
        MoverTileEntity mover;
        ItemStack card;
        BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
        this.selectedVehicle = blockEntity instanceof MoverTileEntity ? ((card = (mover = (MoverTileEntity)blockEntity).getCard()).m_41619_() ? null : VehicleCard.getVehicleName(card)) : null;
    }

    public String getSelectedVehicle() {
        return this.selectedVehicle;
    }

    public void setSelectedVehicle(String vehicle) {
        this.selectedVehicle = this.selectedVehicle;
        if (this.f_58857_.f_46443_) {
            GuiMoverController.setSelectedVehicle(vehicle);
        }
    }

    private void doMove(BlockPos pos, String vehicle) {
    }

    private void doScan() {
        this.m_6596_();
        this.nodes.clear();
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            BlockPos moverPos = this.f_58858_.m_142300_(direction);
            if (!(this.f_58857_.m_7702_(moverPos) instanceof MoverTileEntity)) continue;
            this.graph = new MoverGraphNode(moverPos);
            this.nodes.put(moverPos, this.graph);
            this.doScan(moverPos, this.graph);
            return;
        }
    }

    private void doScan(BlockPos moverPos, MoverGraphNode moverNode) {
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            for (int distance = 1; distance <= 512; ++distance) {
                BlockPos newPos = moverPos.m_5484_(direction, distance);
                if (this.nodes.containsKey(newPos) || !(this.f_58857_.m_7702_(newPos) instanceof MoverTileEntity)) continue;
                MoverGraphNode child = new MoverGraphNode(newPos);
                this.nodes.put(newPos, child);
                moverNode.add(direction, newPos);
                child.add(direction.m_122424_(), moverNode.getPos());
                this.doScan(newPos, child);
            }
        }
    }

    private List<String> getVehicles() {
        ArrayList<String> vehicles = new ArrayList<String>();
        this.nodes.forEach((pos, node) -> {
            MoverTileEntity mover;
            ItemStack card;
            BlockEntity patt8245$temp = this.f_58857_.m_7702_(pos);
            if (patt8245$temp instanceof MoverTileEntity && !(card = (mover = (MoverTileEntity)patt8245$temp).getCard()).m_41619_()) {
                Object name = VehicleCard.getVehicleName(card);
                if (mover.isMoving()) {
                    name = (String)name + " (M)";
                }
                vehicles.add((String)name);
            }
        });
        return vehicles;
    }

    private List<Pair<BlockPos, String>> getNodes() {
        ArrayList<Pair<BlockPos, String>> nodeNames = new ArrayList<Pair<BlockPos, String>>();
        this.nodes.forEach((pos, node) -> {
            BlockEntity patt8863$temp = this.f_58857_.m_7702_(pos);
            if (patt8863$temp instanceof MoverTileEntity) {
                MoverTileEntity mover = (MoverTileEntity)patt8863$temp;
                Object name = mover.getName();
                if (name == null || ((String)name).trim().isEmpty()) {
                    name = pos.m_123341_() + "," + pos.m_123342_() + "," + pos.m_123343_();
                }
                nodeNames.add(Pair.of((Object)pos, (Object)name));
            } else {
                nodeNames.add(Pair.of((Object)pos, (Object)"<INVALID>"));
            }
        });
        return nodeNames;
    }

    public static class NodePairSerializer
    implements ISerializer<Pair<BlockPos, String>> {
        public Function<FriendlyByteBuf, Pair<BlockPos, String>> getDeserializer() {
            return buf -> Pair.of((Object)buf.m_130135_(), (Object)buf.m_130136_(Short.MAX_VALUE));
        }

        public BiConsumer<FriendlyByteBuf, Pair<BlockPos, String>> getSerializer() {
            return (buf, pair) -> {
                buf.m_130064_((BlockPos)pair.getLeft());
                buf.m_130070_((String)pair.getRight());
            };
        }
    }
}

