/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.MultiblockPositions;
import com.blakebr0.mysticalagriculture.api.crafting.IInfusionRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.RecipeTypes;
import com.blakebr0.mysticalagriculture.crafting.recipe.InfusionRecipe;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.tileentity.InfusionPedestalTileEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;

public class InfusionAltarTileEntity
extends BaseInventoryTileEntity {
    private final BaseItemStackHandler inventory;
    private final BaseItemStackHandler recipeInventory;
    private final MultiblockPositions pedestalLocations = new MultiblockPositions.Builder().pos(3, 0, 0).pos(0, 0, 3).pos(-3, 0, 0).pos(0, 0, -3).pos(2, 0, 2).pos(2, 0, -2).pos(-2, 0, 2).pos(-2, 0, -2).build();
    private InfusionRecipe recipe;
    private int progress;
    private boolean active;

    public InfusionAltarTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.INFUSION_ALTAR.get(), pos, state);
        this.inventory = InfusionAltarTileEntity.createInventoryHandler(() -> ((InfusionAltarTileEntity)this).markDirtyAndDispatch());
        this.recipeInventory = new BaseItemStackHandler(9);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("Progress");
        this.active = tag.m_128471_("Active");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Progress", this.progress);
        tag.m_128379_("Active", this.active);
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, InfusionAltarTileEntity tile) {
        ItemStack input = tile.inventory.getStackInSlot(0);
        if (input.m_41619_()) {
            tile.reset();
            return;
        }
        if (tile.isActive()) {
            List<InfusionPedestalTileEntity> pedestals = tile.getPedestals();
            tile.updateRecipeInventory(pedestals);
            if (tile.recipe == null || !tile.recipe.matches((IItemHandler)tile.recipeInventory)) {
                IInfusionRecipe recipe = level.m_7465_().m_44015_(RecipeTypes.INFUSION, tile.recipeInventory.toIInventory(), level).orElse(null);
                InfusionRecipe infusionRecipe = tile.recipe = recipe instanceof InfusionRecipe ? (InfusionRecipe)recipe : null;
            }
            if (tile.recipe != null) {
                ++tile.progress;
                if (tile.progress >= 100) {
                    NonNullList remaining = tile.recipe.getRemainingItems((IItemHandler)tile.recipeInventory);
                    for (int i = 0; i < pedestals.size(); ++i) {
                        InfusionPedestalTileEntity pedestal2 = pedestals.get(i);
                        pedestal2.getInventory().setStackInSlot(0, (ItemStack)remaining.get(i + 1));
                        tile.spawnParticles(ParticleTypes.f_123762_, pedestal2.m_58899_(), 1.2, 20);
                    }
                    ItemStack result = tile.recipe.assemble((IItemHandler)tile.recipeInventory);
                    tile.setOutput(result);
                    tile.reset();
                    tile.markDirtyAndDispatch();
                    tile.spawnParticles(ParticleTypes.f_123748_, pos, 1.0, 10);
                } else {
                    pedestals.forEach(pedestal -> {
                        BlockPos pedestalPos = pedestal.m_58899_();
                        ItemStack stack = pedestal.getInventory().getStackInSlot(0);
                        tile.spawnItemParticles(pedestalPos, stack);
                    });
                }
            } else {
                tile.reset();
            }
        } else {
            tile.progress = 0;
        }
    }

    public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
        BaseItemStackHandler inventory = new BaseItemStackHandler(2, onContentsChanged);
        inventory.setDefaultSlotLimit(1);
        inventory.setSlotValidator((slot, stack) -> inventory.getStackInSlot(1).m_41619_());
        inventory.setOutputSlots(new int[]{1});
        return inventory;
    }

    public List<BlockPos> getPedestalPositions() {
        return this.pedestalLocations.get(this.m_58899_());
    }

    public boolean isActive() {
        if (!this.active) {
            Level world = this.m_58904_();
            this.active = world != null && world.m_46753_(this.m_58899_());
        }
        return this.active;
    }

    public void setActive() {
        this.active = true;
    }

    private void reset() {
        this.progress = 0;
        this.active = false;
    }

    private void updateRecipeInventory(List<InfusionPedestalTileEntity> pedestals) {
        this.recipeInventory.setSize(9);
        this.recipeInventory.setStackInSlot(0, this.inventory.getStackInSlot(0));
        for (int i = 0; i < pedestals.size(); ++i) {
            ItemStack stack = pedestals.get(i).getInventory().getStackInSlot(0);
            this.recipeInventory.setStackInSlot(i + 1, stack);
        }
    }

    private List<InfusionPedestalTileEntity> getPedestals() {
        if (this.m_58904_() == null) {
            return new ArrayList<InfusionPedestalTileEntity>();
        }
        ArrayList<InfusionPedestalTileEntity> pedestals = new ArrayList<InfusionPedestalTileEntity>();
        this.getPedestalPositions().forEach(pos -> {
            BlockEntity tile = this.m_58904_().m_7702_(pos);
            if (tile instanceof InfusionPedestalTileEntity) {
                InfusionPedestalTileEntity pedestal = (InfusionPedestalTileEntity)tile;
                pedestals.add(pedestal);
            }
        });
        return pedestals;
    }

    private <T extends ParticleOptions> void spawnParticles(T particle, BlockPos pos, double yOffset, int count) {
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.m_58904_();
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + yOffset;
        double z = (double)pos.m_123343_() + 0.5;
        level.m_8767_(particle, x, y, z, count, 0.0, 0.0, 0.0, 0.1);
    }

    private void spawnItemParticles(BlockPos pedestalPos, ItemStack stack) {
        if (this.m_58904_() == null || this.m_58904_().m_5776_() || stack.m_41619_()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.m_58904_();
        BlockPos pos = this.m_58899_();
        double x = (double)pedestalPos.m_123341_() + level.m_5822_().nextDouble() * 0.2 + 0.4;
        double y = (double)pedestalPos.m_123342_() + level.m_5822_().nextDouble() * 0.2 + 1.2;
        double z = (double)pedestalPos.m_123343_() + level.m_5822_().nextDouble() * 0.2 + 0.4;
        double velX = pos.m_123341_() - pedestalPos.m_123341_();
        double velY = 0.25;
        double velZ = pos.m_123343_() - pedestalPos.m_123343_();
        level.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), x, y, z, 0, velX, velY, velZ, 0.18);
    }

    private void setOutput(ItemStack stack) {
        this.inventory.getStacks().set(0, (Object)ItemStack.f_41583_);
        this.inventory.getStacks().set(1, (Object)stack);
    }
}

