/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.crafting.ingredient.FilledSoulJarIngredient;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.item.SoulJarItem;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SoulJarEmptyRecipe
extends ShapelessRecipe {
    public SoulJarEmptyRecipe(ResourceLocation id, String group, ItemStack output, NonNullList<Ingredient> inputs) {
        super(id, group, output, inputs);
    }

    public boolean m_5818_(CraftingContainer inv, Level world) {
        boolean hasJar = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (hasJar && !stack.m_41619_()) {
                return false;
            }
            Item item = stack.m_41720_();
            if (item instanceof SoulJarItem) {
                double souls = MobSoulUtils.getSouls(stack);
                if (!(souls > 0.0)) continue;
                hasJar = true;
                continue;
            }
            if (stack.m_41619_()) continue;
            return false;
        }
        return hasJar;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipeSerializers.CRAFTING_SOUL_JAR_EMPTY;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<SoulJarEmptyRecipe> {
        public SoulJarEmptyRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList ingredients = NonNullList.m_122780_((int)1, (Object)((Object)new FilledSoulJarIngredient()));
            return new SoulJarEmptyRecipe(recipeId, "", new ItemStack((ItemLike)ModItems.SOUL_JAR.get()), (NonNullList<Ingredient>)ingredients);
        }

        public SoulJarEmptyRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            NonNullList ingredients = NonNullList.m_122780_((int)1, (Object)((Object)new FilledSoulJarIngredient()));
            return new SoulJarEmptyRecipe(recipeId, "", new ItemStack((ItemLike)ModItems.SOUL_JAR.get()), (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, SoulJarEmptyRecipe recipe) {
        }
    }
}

