/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.registry;

import java.util.function.Supplier;
import net.darkhax.bookshelf.api.ClientServices;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.block.IBindRenderLayer;
import net.darkhax.bookshelf.api.block.IItemBlockProvider;
import net.darkhax.bookshelf.api.commands.ICommandBuilder;
import net.darkhax.bookshelf.api.data.recipes.IRecipeSerializer;
import net.darkhax.bookshelf.api.registry.ClassRegistryEntries;
import net.darkhax.bookshelf.api.registry.IOwnedRegistryEntries;
import net.darkhax.bookshelf.api.registry.RecipeTypeEntries;
import net.darkhax.bookshelf.api.registry.RegistryEntries;
import net.darkhax.bookshelf.api.registry.VillagerTradeEntries;
import net.darkhax.bookshelf.mixin.item.AccessorItem;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;

public class RegistryDataProvider {
    private final String ownerId;
    public final IOwnedRegistryEntries<Block> blocks = new RegistryEntries<Block>(this::getOwner, Registry.f_122901_);
    public final IOwnedRegistryEntries<Fluid> fluids = new RegistryEntries<Fluid>(this::getOwner, Registry.f_122899_);
    public final IOwnedRegistryEntries<Item> items = new RegistryEntries<Item>(this::getOwner, Registry.f_122904_);
    public final IOwnedRegistryEntries<MobEffect> mobEffects = new RegistryEntries<MobEffect>(this::getOwner, Registry.f_122900_);
    public final IOwnedRegistryEntries<SoundEvent> sounds = new RegistryEntries<SoundEvent>(this::getOwner, Registry.f_122898_);
    public final IOwnedRegistryEntries<Potion> potions = new RegistryEntries<Potion>(this::getOwner, Registry.f_122905_);
    public final IOwnedRegistryEntries<Enchantment> enchantments = new RegistryEntries<Enchantment>(this::getOwner, Registry.f_122902_);
    public final IOwnedRegistryEntries<EntityType<?>> entities = new RegistryEntries(this::getOwner, Registry.f_122903_);
    public final IOwnedRegistryEntries<BlockEntityType<?>> blockEntities = new RegistryEntries(this::getOwner, Registry.f_122907_);
    public final IOwnedRegistryEntries<ParticleType<?>> particleTypes = new RegistryEntries(this::getOwner, Registry.f_122906_);
    public final IOwnedRegistryEntries<MenuType<?>> menus = new RegistryEntries(this::getOwner, Registry.f_122913_);
    public final IOwnedRegistryEntries<IRecipeSerializer<?>> recipeSerializers = new RegistryEntries(this::getOwner, Registry.f_122915_);
    public final IOwnedRegistryEntries<Motive> paintings = new RegistryEntries<Motive>(this::getOwner, Registry.f_122908_);
    public final IOwnedRegistryEntries<Attribute> attributes = new RegistryEntries<Attribute>(this::getOwner, Registry.f_122916_);
    public final IOwnedRegistryEntries<StatType<?>> stats = new RegistryEntries(this::getOwner, Registry.f_122917_);
    public final IOwnedRegistryEntries<VillagerProfession> villagerProfessions = new RegistryEntries<VillagerProfession>(this::getOwner, Registry.f_122809_);
    public final IOwnedRegistryEntries<MenuType<?>> menuTypes = new RegistryEntries(this::getOwner, Registry.f_122913_);
    public final RecipeTypeEntries recipeTypes = new RecipeTypeEntries(this::getOwner);
    public final ClassRegistryEntries<ArgumentSerializer> commandArguments = new ClassRegistryEntries(this::getOwner, "Command Argument");
    public final IOwnedRegistryEntries<ICommandBuilder> commands = new RegistryEntries<ICommandBuilder>(this::getOwner, "Command");
    public final VillagerTradeEntries trades = new VillagerTradeEntries();
    public final IOwnedRegistryEntries<PreparableReloadListener> resourceListeners = new RegistryEntries<PreparableReloadListener>(this::getOwner, "Resource Listener");
    public final IOwnedRegistryEntries<PreparableReloadListener> dataListeners = new RegistryEntries<PreparableReloadListener>(this::getOwner, "Data Listener");

    public RegistryDataProvider(String ownerId) {
        this.ownerId = ownerId;
    }

    public final RegistryDataProvider withCreativeTab(Supplier<? extends ItemLike> iconProvider) {
        return this.withCreativeTab(iconProvider, "creative_tab");
    }

    public final RegistryDataProvider withCreativeTab(Supplier<? extends ItemLike> iconProvider, String id) {
        return this.withCreativeTab(Services.CONSTRUCTS.creativeTab(this.ownerId, id).setIcon(iconProvider).build());
    }

    public final RegistryDataProvider withCreativeTab(CreativeModeTab tab) {
        this.items.addRegistryListener((id, item) -> {
            if (item instanceof AccessorItem) {
                AccessorItem accessor = (AccessorItem)item;
                accessor.bookshelf$setCreativeTab(tab);
            }
        });
        return this;
    }

    public final RegistryDataProvider bindBlockRenderLayers() {
        if (Services.PLATFORM.isPhysicalClient()) {
            this.blocks.addRegistryListener((id, block) -> {
                if (block instanceof IBindRenderLayer) {
                    IBindRenderLayer binder = (IBindRenderLayer)block;
                    ClientServices.CLIENT.setRenderType((Block)block, binder.getRenderLayerToBind());
                }
            });
        }
        return this;
    }

    public final RegistryDataProvider withAutoItemBlocks() {
        this.blocks.addInsertListener((id, block) -> this.items.add(() -> {
            if (block instanceof IItemBlockProvider) {
                IItemBlockProvider provider = (IItemBlockProvider)((Object)block);
                return provider.createItemBlock((Block)block.get());
            }
            return IItemBlockProvider.DEFAULT.createItemBlock((Block)block.get());
        }, (ResourceLocation)id));
        return this;
    }

    public String getOwner() {
        return this.ownerId;
    }
}

