/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.block.entity.dynamo;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.block.entity.IPacketHandlerTile;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.util.managers.dynamo.CompressionFuelManager;
import cofh.thermal.expansion.init.TExpTileEntities;
import cofh.thermal.expansion.inventory.container.dynamo.DynamoCompressionContainer;
import cofh.thermal.lib.tileentity.DynamoTileBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fluids.FluidStack;

public class DynamoCompressionTile
extends DynamoTileBase {
    protected FluidStorageCoFH fuelTank = new FluidStorageCoFH(4000, fluid -> this.filter.valid(fluid) && CompressionFuelManager.instance().validFuel(fluid));

    public DynamoCompressionTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TExpTileEntities.DYNAMO_COMPRESSION_TILE.get(), pos, state);
        this.tankInv.addTank(this.fuelTank, StorageGroup.INPUT);
        this.renderFluid = new FluidStack((Fluid)Fluids.f_76193_, 1000);
        this.addAugmentSlots(ThermalCoreConfig.dynamoAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return CompressionFuelManager.instance().getBasePower();
    }

    protected boolean canProcessStart() {
        return CompressionFuelManager.instance().getEnergy(this.fuelTank.getFluidStack()) > 0 && this.fuelTank.getAmount() >= 100;
    }

    protected void processStart() {
        if (this.cacheRenderFluid()) {
            TileStatePacket.sendToClient((IPacketHandlerTile)this);
        }
        this.fuelMax = Math.round((float)CompressionFuelManager.instance().getEnergy(this.fuelTank.getFluidStack()) * this.energyMod);
        this.fuel += this.fuelMax;
        this.fuelTank.modify(-100);
    }

    protected boolean cacheRenderFluid() {
        FluidStack prevFluid = this.renderFluid;
        this.renderFluid = new FluidStack(this.fuelTank.getFluidStack(), 1000);
        return !FluidHelper.fluidsEqual((FluidStack)this.renderFluid, (FluidStack)prevFluid);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new DynamoCompressionContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ModelUtils.FLUID, (Object)this.renderFluid).build();
    }
}

