/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import website.eccentric.tome.EccentricTome;
import website.eccentric.tome.Tag;
import website.eccentric.tome.services.ModName;

public class Tome {
    public static ItemStack convert(ItemStack tome, ItemStack book) {
        Map<String, List<ItemStack>> modsBooks = Tag.getModsBooks(tome);
        String mod = ModName.from(book);
        List<Object> books = modsBooks.get(mod);
        ResourceLocation registry = book.m_41720_().getRegistryName();
        books = books.stream().filter(b -> !b.m_41720_().getRegistryName().equals((Object)registry)).collect(Collectors.toList());
        modsBooks.put(mod, books);
        Tag.setModsBooks(tome, modsBooks);
        String name = book.m_41786_().getString();
        Tag.copyMods(tome, book);
        Tag.fill(book, true);
        Tome.setHoverName(book, name);
        return book;
    }

    public static ItemStack revert(ItemStack book) {
        ItemStack tome = Tome.createStack();
        Tag.copyMods(book, tome);
        Tag.clear(book);
        book.m_41787_();
        return tome;
    }

    public static ItemStack attach(ItemStack tome, ItemStack book) {
        String mod = ModName.from(book);
        Map<String, List<ItemStack>> modsBooks = Tag.getModsBooks(tome);
        List books = modsBooks.getOrDefault(mod, new ArrayList());
        books.add(book);
        modsBooks.put(mod, books);
        Tag.setModsBooks(tome, modsBooks);
        return tome;
    }

    private static ItemStack createStack() {
        return Tag.initialize(new ItemStack((ItemLike)EccentricTome.TOME.get()));
    }

    private static void setHoverName(ItemStack book, String name) {
        MutableComponent bookName = new TextComponent(name).m_6270_(Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.GREEN}));
        book.m_41714_((Component)new TranslatableComponent("eccentrictome.name", new Object[]{bookName}));
    }
}

