/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome.services;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import website.eccentric.tome.services.Configuration;

public class ModName {
    private static final Map<String, String> modNames = new HashMap<String, String>();

    public static String from(BlockState state) {
        return ModName.orAlias(state.m_60734_().getRegistryName().m_135827_());
    }

    public static String from(ItemStack stack) {
        String minecraft = "minecraft";
        String patchouli = "patchouli";
        String patchouliBook = patchouli + ":book";
        if (stack.m_41619_()) {
            return minecraft;
        }
        String mod = stack.m_41720_().getCreatorModId(stack);
        if (mod.equals(patchouli)) {
            String book = stack.m_41783_().m_128461_(patchouliBook);
            mod = new ResourceLocation(book).m_135827_();
        }
        return ModName.orAlias(mod);
    }

    public static String orAlias(String mod) {
        return Configuration.aliases().getOrDefault(mod, mod);
    }

    public static String name(String mod) {
        return modNames.getOrDefault(mod, mod);
    }

    static {
        for (IModInfo mod : ModList.get().getMods()) {
            modNames.put(mod.getModId(), mod.getDisplayName());
        }
    }
}

