/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import website.eccentric.tome.Migration;

public class Tag {
    public static final String MODS = "eccentrictome:mods";
    public static final String IS_TOME = "eccentrictome:is_tome";

    public static ItemStack initialize(ItemStack stack) {
        CompoundTag tag = Tag.getOrSetTag(stack);
        Migration.setCurrentVersion(tag);
        tag.m_128365_(MODS, (net.minecraft.nbt.Tag)new CompoundTag());
        return stack;
    }

    public static Map<String, List<ItemStack>> getModsBooks(ItemStack stack) {
        CompoundTag tag = Tag.getOrSetTag(stack);
        Migration.Apply(tag);
        HashMap<String, List<ItemStack>> books = new HashMap<String, List<ItemStack>>();
        CompoundTag mods = tag.m_128469_(MODS);
        for (String mod : mods.m_128431_()) {
            CompoundTag booksTag = mods.m_128469_(mod);
            List booksList = books.getOrDefault(mod, new ArrayList());
            for (String book : booksTag.m_128431_()) {
                booksList.add(ItemStack.m_41712_((CompoundTag)booksTag.m_128469_(book)));
            }
            books.put(mod, booksList);
        }
        return books;
    }

    public static void setModsBooks(ItemStack stack, Map<String, List<ItemStack>> modsBooks) {
        CompoundTag tag = Tag.getOrSetTag(stack);
        Migration.Apply(tag);
        CompoundTag mods = new CompoundTag();
        for (String mod : modsBooks.keySet()) {
            CompoundTag booksTag = new CompoundTag();
            List<ItemStack> booksList = modsBooks.get(mod);
            for (int i = 0; i < booksList.size(); ++i) {
                String key = Integer.toString(i);
                CompoundTag bookTag = booksList.get(i).m_41739_(new CompoundTag());
                booksTag.m_128365_(key, (net.minecraft.nbt.Tag)bookTag);
            }
            if (booksList.isEmpty()) continue;
            mods.m_128365_(mod, (net.minecraft.nbt.Tag)booksTag);
        }
        tag.m_128365_(MODS, (net.minecraft.nbt.Tag)mods);
    }

    public static CompoundTag getOrSetTag(ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        return stack.m_41783_();
    }

    public static CompoundTag getOrSetMods(CompoundTag tag) {
        if (!tag.m_128441_(MODS)) {
            tag.m_128365_(MODS, (net.minecraft.nbt.Tag)new CompoundTag());
        }
        return tag.m_128469_(MODS);
    }

    public static void setMods(ItemStack stack, CompoundTag mods) {
        Tag.getOrSetTag(stack).m_128365_(MODS, (net.minecraft.nbt.Tag)mods);
    }

    public static void copyMods(ItemStack source, ItemStack target) {
        CompoundTag mods = Tag.getOrSetMods(Tag.getOrSetTag(source)).m_6426_();
        Tag.getOrSetTag(target).m_128365_(MODS, (net.minecraft.nbt.Tag)mods);
    }

    public static boolean isTome(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128471_(IS_TOME);
    }

    public static void clear(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        tag.m_128473_(MODS);
        tag.m_128473_(IS_TOME);
        if (tag.m_128456_()) {
            stack.m_41751_(null);
        }
    }

    public static void fill(ItemStack stack, boolean isTome) {
        CompoundTag tag = stack.m_41783_();
        tag.m_128379_(IS_TOME, isTome);
    }
}

