/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome;

import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import website.eccentric.tome.AttachmentRecipe;
import website.eccentric.tome.CommonConfiguration;
import website.eccentric.tome.TomeItem;
import website.eccentric.tome.TomeRecipe;
import website.eccentric.tome.client.gui.RenderGameOverlayHandler;
import website.eccentric.tome.client.gui.TomeHandler;
import website.eccentric.tome.network.RevertMessage;
import website.eccentric.tome.network.TomeChannel;
import website.eccentric.tome.services.Configuration;
import website.eccentric.tome.services.Tome;

@Mod(value="eccentrictome")
public class EccentricTome {
    public static final String MODID = "eccentrictome";
    public static final Logger LOGGER = LogManager.getLogger((String)"eccentrictome");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"eccentrictome");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"eccentrictome");
    public static final RegistryObject<RecipeSerializer<?>> ATTACHMENT = RECIPES.register("attachment", EccentricTome::registerSerializer);
    public static final RegistryObject<Item> TOME = ITEMS.register("tome", TomeItem::new);
    public static SimpleChannel CHANNEL;

    public EccentricTome() {
        IEventBus modEvent = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(modEvent);
        RECIPES.register(modEvent);
        modEvent.addListener(this::onClientSetup);
        modEvent.addListener(this::onCommonSetup);
        modEvent.addListener(this::onGatherData);
        modEvent.addListener(this::onModConfig);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfiguration.SPEC);
        IEventBus minecraftEvent = MinecraftForge.EVENT_BUS;
        minecraftEvent.addListener(this::onPlayerLeftClick);
        minecraftEvent.addListener(EventPriority.LOW, this::onItemDropped);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, RenderGameOverlayHandler::onRender);
        MinecraftForge.EVENT_BUS.addListener(TomeHandler::onOpenTome);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        CHANNEL = TomeChannel.register();
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        generator.m_123914_((DataProvider)new TomeRecipe(generator));
    }

    private void onModConfig(ModConfigEvent event) {
        Configuration.refresh();
    }

    private void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getItemStack();
        if (TomeItem.isTome(stack) && !(stack.m_41720_() instanceof TomeItem)) {
            CHANNEL.sendToServer((Object)new RevertMessage());
        }
    }

    private void onItemDropped(ItemTossEvent event) {
        if (!event.getPlayer().m_6144_()) {
            return;
        }
        ItemEntity entity = event.getEntityItem();
        ItemStack stack = entity.m_32055_();
        if (TomeItem.isTome(stack) && !(stack.m_41720_() instanceof TomeItem)) {
            ItemStack detatchment = Tome.revert(stack);
            Level level = entity.m_20193_();
            if (!level.f_46443_) {
                level.m_7967_((Entity)new ItemEntity(level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), detatchment));
            }
            entity.m_32045_(stack);
        }
    }

    private static RecipeSerializer<?> registerSerializer() {
        AttachmentRecipe.SERIALIZER = new SimpleRecipeSerializer(AttachmentRecipe::new);
        return AttachmentRecipe.SERIALIZER;
    }
}

