/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.setup;

import cy.jdkdigital.productivebees.client.particle.FallingNectarParticle;
import cy.jdkdigital.productivebees.client.particle.LavaNectarParticle;
import cy.jdkdigital.productivebees.client.particle.PoppingNectarParticle;
import cy.jdkdigital.productivebees.client.particle.PortalNectarParticle;
import cy.jdkdigital.productivebees.client.particle.RisingNectarParticle;
import cy.jdkdigital.productivebees.client.render.block.BottlerTileEntityRenderer;
import cy.jdkdigital.productivebees.client.render.block.CentrifugeTileEntityRenderer;
import cy.jdkdigital.productivebees.client.render.block.FeederBlockEntityRenderer;
import cy.jdkdigital.productivebees.client.render.block.JarTileEntityRenderer;
import cy.jdkdigital.productivebees.common.item.BeeBomb;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.common.item.HoneyTreat;
import cy.jdkdigital.productivebees.common.item.NestLocator;
import cy.jdkdigital.productivebees.container.gui.AdvancedBeehiveScreen;
import cy.jdkdigital.productivebees.container.gui.BottlerScreen;
import cy.jdkdigital.productivebees.container.gui.BreedingChamberScreen;
import cy.jdkdigital.productivebees.container.gui.CatcherScreen;
import cy.jdkdigital.productivebees.container.gui.CentrifugeScreen;
import cy.jdkdigital.productivebees.container.gui.FeederScreen;
import cy.jdkdigital.productivebees.container.gui.GeneIndexerScreen;
import cy.jdkdigital.productivebees.container.gui.HoneyGeneratorScreen;
import cy.jdkdigital.productivebees.container.gui.IncubatorScreen;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModParticles;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="productivebees", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetup {
    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.ADVANCED_BEEHIVE.get()), AdvancedBeehiveScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.CENTRIFUGE.get()), CentrifugeScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.POWERED_CENTRIFUGE.get()), CentrifugeScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.HEATED_CENTRIFUGE.get()), CentrifugeScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.BOTTLER.get()), BottlerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.FEEDER.get()), FeederScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.INCUBATOR.get()), IncubatorScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.CATCHER.get()), CatcherScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.HONEY_GENERATOR.get()), HoneyGeneratorScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.GENE_INDEXER.get()), GeneIndexerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.BREEDING_CHAMBER.get()), BreedingChamberScreen::new);
            ItemProperties.register((Item)((Item)ModItems.BEE_CAGE.get()), (ResourceLocation)new ResourceLocation("filled"), (stack, world, entity, i) -> BeeCage.isFilled(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ModItems.STURDY_BEE_CAGE.get()), (ResourceLocation)new ResourceLocation("filled"), (stack, world, entity, i) -> BeeCage.isFilled(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ModItems.BEE_BOMB.get()), (ResourceLocation)new ResourceLocation("loaded"), (stack, world, entity, i) -> BeeBomb.isLoaded(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ModItems.HONEY_TREAT.get()), (ResourceLocation)new ResourceLocation("genetic"), (stack, world, entity, i) -> HoneyTreat.hasGene(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ModItems.GENE.get()), (ResourceLocation)new ResourceLocation("genetic"), (stack, world, entity, i) -> Gene.color(stack));
            ItemProperties.register((Item)((Item)ModItems.NEST_LOCATOR.get()), (ResourceLocation)new ResourceLocation("angle"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){

                public float m_142187_(@Nonnull ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity player, int i) {
                    if ((player != null || stack.m_41794_()) && NestLocator.hasPosition(stack)) {
                        LivingEntity entity;
                        boolean flag = player != null;
                        Object object = entity = flag ? player : stack.m_41795_();
                        if (world == null && entity != null && entity.f_19853_ instanceof ClientLevel) {
                            world = (ClientLevel)entity.f_19853_;
                        }
                        BlockPos pos = NestLocator.getPosition(stack);
                        if (entity != null && world != null && pos != null) {
                            double d1 = flag ? (double)entity.m_146908_() : this.getFrameRotation((ItemFrame)entity);
                            d1 = Mth.m_14109_((double)(d1 / 360.0), (double)1.0);
                            double d2 = this.getPositionToAngle(pos, (Entity)entity) / 6.2831854820251465;
                            double d0 = 0.5 - (d1 - 0.25 - d2);
                            return Mth.m_14091_((float)((float)d0), (float)1.0f);
                        }
                    }
                    return 0.5f;
                }

                private double getFrameRotation(ItemFrame frameEntity) {
                    return Mth.m_14098_((int)(180 + frameEntity.m_6350_().m_122416_() * 90));
                }

                private double getPositionToAngle(BlockPos blockpos, Entity entityIn) {
                    return Math.atan2((double)blockpos.m_123343_() - entityIn.m_20189_(), (double)blockpos.m_123341_() - entityIn.m_20185_());
                }
            });
        });
        ClientSetup.registerBlockRendering();
    }

    @SubscribeEvent
    public static void registerParticles(ParticleFactoryRegisterEvent event) {
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModParticles.COLORED_FALLING_NECTAR.get(), FallingNectarParticle.FallingNectarFactory::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModParticles.COLORED_RISING_NECTAR.get(), RisingNectarParticle.RisingNectarFactory::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModParticles.COLORED_POPPING_NECTAR.get(), PoppingNectarParticle.PoppingNectarFactory::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModParticles.COLORED_LAVA_NECTAR.get(), LavaNectarParticle.LavaNectarFactory::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModParticles.COLORED_PORTAL_NECTAR.get(), PortalNectarParticle.PortalNectarFactory::new);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModTileEntityTypes.CENTRIFUGE.get(), CentrifugeTileEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModTileEntityTypes.POWERED_CENTRIFUGE.get(), CentrifugeTileEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModTileEntityTypes.BOTTLER.get(), BottlerTileEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModTileEntityTypes.FEEDER.get(), FeederBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModTileEntityTypes.JAR.get(), JarTileEntityRenderer::new);
    }

    private static void registerBlockRendering() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.COMB_GHOSTLY.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SLIMY_NEST.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.BUMBLE_BEE_NEST.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SUGAR_CANE_NEST.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.JAR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.INVISIBLE_REDSTONE_BLOCK.get()), (RenderType)RenderType.m_110463_());
    }
}

