/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import cy.jdkdigital.productivebees.common.recipe.BeeSpawningRecipe;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.integrations.jei.BeeSpawningRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.ProductiveBeesJeiPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BeeSpawningRecipeBigCategory
extends BeeSpawningRecipeCategory {
    private final IDrawable background;
    private final IDrawable icon;
    public static final HashMap<Integer, List<Integer>> BEE_POSITIONS = new HashMap<Integer, List<Integer>>(){
        {
            this.put(0, new ArrayList<Integer>(){
                {
                    this.add(66);
                    this.add(18);
                }
            });
            this.put(1, new ArrayList<Integer>(){
                {
                    this.add(66);
                    this.add(38);
                }
            });
            this.put(2, new ArrayList<Integer>(){
                {
                    this.add(84);
                    this.add(28);
                }
            });
            this.put(3, new ArrayList<Integer>(){
                {
                    this.add(102);
                    this.add(18);
                }
            });
            this.put(4, new ArrayList<Integer>(){
                {
                    this.add(102);
                    this.add(38);
                }
            });
        }
    };

    public BeeSpawningRecipeBigCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/bee_spawning_recipe_big.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.OAK_WOOD_NEST.get()));
    }

    @Override
    @Nonnull
    public ResourceLocation getUid() {
        return ProductiveBeesJeiPlugin.CATEGORY_BEE_SPAWNING_BIG_UID;
    }

    @Override
    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, BeeSpawningRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 4, 26);
        itemStacks.set(ingredients);
        IGuiIngredientGroup ingredientStacks = recipeLayout.getIngredientsGroup(ProductiveBeesJeiPlugin.BEE_INGREDIENT);
        int offset = ingredients.getInputs(ProductiveBeesJeiPlugin.BEE_INGREDIENT).size();
        IntStream.range(offset, recipe.output.size() + offset).forEach(i -> {
            if (i - offset > 3) {
                return;
            }
            List<Integer> pos = BEE_POSITIONS.get(i - offset);
            ingredientStacks.init(i, false, pos.get(0).intValue(), pos.get(1).intValue());
        });
        ingredientStacks.set(ingredients);
    }
}

