/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.recipe.BeeSpawningRecipe;
import cy.jdkdigital.productivebees.init.ModFeatures;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class WoodNestDecorator
extends TreeDecorator {
    public static final Codec<WoodNestDecorator> CODEC = Codec.unit(WoodNestDecorator::new);
    private static final Direction[] SPAWN_DIRECTIONS = (Direction[])Direction.Plane.HORIZONTAL.m_122557_().filter(direction -> direction != Direction.SOUTH.m_122424_()).toArray(Direction[]::new);
    private BlockState nest;
    private List<BeeSpawningRecipe> recipes;

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)ModFeatures.WOOD_NEST.get();
    }

    public void setNest(BlockState nest) {
        this.nest = nest;
    }

    public void setBeeRecipes(List<BeeSpawningRecipe> recipe) {
        this.recipes = recipe;
    }

    public void m_142741_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, Random random, List<BlockPos> pLogPositions, List<BlockPos> pLeafPositions) {
        List<Direction> nestDirections;
        BlockPos nestPos;
        int i = !pLeafPositions.isEmpty() ? Math.max(pLeafPositions.get(0).m_123342_() - 1, pLogPositions.get(0).m_123342_() + 1) : Math.min(pLogPositions.get(0).m_123342_() + 1 + random.nextInt(3), pLogPositions.get(pLogPositions.size() - 1).m_123342_());
        List<BlockPos> list = pLogPositions.stream().filter(pos -> pos.m_123342_() == i).flatMap(pos -> Stream.of(SPAWN_DIRECTIONS).map(direction -> Feature.m_65810_((LevelSimulatedReader)pLevel, (BlockPos)pos.m_142300_(direction)) ? pos : null)).filter(Objects::nonNull).toList();
        if (!list.isEmpty() && this.nest != null && (nestPos = list.get(list.size() <= 1 ? 0 : random.nextInt(list.size()))) != null && !(nestDirections = Stream.of(SPAWN_DIRECTIONS).filter(direction -> Feature.m_65810_((LevelSimulatedReader)pLevel, (BlockPos)nestPos.m_142300_(direction))).toList()).isEmpty()) {
            pBlockSetter.accept(nestPos, (BlockState)this.nest.m_60734_().m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)(nestDirections.size() == 1 ? nestDirections.get(0) : nestDirections.get(random.nextInt(nestDirections.size())))));
            pLevel.m_141902_(nestPos, (BlockEntityType)ModTileEntityTypes.SOLITARY_NEST.get()).ifPresent(nestBlockEntity -> {
                ProductiveBees.LOGGER.debug("Spawned wood nest at " + nestPos + " " + this.nest);
                if (!this.recipes.isEmpty()) {
                    BeeSpawningRecipe spawningRecipe = this.recipes.get(random.nextInt(this.recipes.size()));
                    if (!spawningRecipe.output.isEmpty()) {
                        BeeIngredient beeIngredient = (BeeIngredient)spawningRecipe.output.get(random.nextInt(spawningRecipe.output.size())).get();
                        try {
                            CompoundTag bee = BeeHelper.getBeeAsCompoundTag(beeIngredient);
                            nestBlockEntity.addBee(bee, random.nextInt(599), 600, null, new TranslatableComponent("entity.productivebees." + beeIngredient.getBeeType().m_135815_()).getString());
                        }
                        catch (CommandSyntaxException e) {
                            ProductiveBees.LOGGER.warn("Failed to put bees into solitary nest :(" + e.getMessage());
                        }
                    }
                }
            });
        }
    }
}

