/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.block.SolitaryNest;
import cy.jdkdigital.productivebees.common.recipe.BeeSpawningRecipe;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class GlowstoneNestFeature
extends Feature<BlockStateConfiguration> {
    public static final Codec<BlockStateConfiguration> CODEC = RecordCodecBuilder.create(conf -> conf.group((App)BlockState.f_61039_.fieldOf("state").forGetter(configuration -> configuration.f_67547_)).apply((Applicative)conf, BlockStateConfiguration::new));

    public GlowstoneNestFeature(Codec<BlockStateConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<BlockStateConfiguration> conf) {
        WorldGenLevel worldgenlevel = conf.m_159774_();
        BlockPos blockpos = conf.m_159777_();
        Random random = conf.m_159776_();
        if (!worldgenlevel.m_46859_(blockpos)) {
            return false;
        }
        BlockState blockstate = worldgenlevel.m_8055_(blockpos.m_7494_());
        if (!(blockstate.m_60713_(Blocks.f_50134_) || blockstate.m_60713_(Blocks.f_50137_) || blockstate.m_60713_(Blocks.f_50730_))) {
            return false;
        }
        BlockState glowstone = Blocks.f_50141_.m_49966_();
        HashSet set = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> glowstoneConsumer = (pos, blockState) -> {
            set.add(pos.m_7949_());
            worldgenlevel.m_7731_(pos, blockState, 2);
        };
        glowstoneConsumer.accept(blockpos, glowstone);
        for (int i = 0; i < 1500; ++i) {
            BlockPos blockpos1 = blockpos.m_142082_(random.nextInt(8) - random.nextInt(8), -random.nextInt(12), random.nextInt(8) - random.nextInt(8));
            if (!worldgenlevel.m_8055_(blockpos1).m_60795_()) continue;
            int j = 0;
            for (Direction direction : Direction.values()) {
                if (worldgenlevel.m_8055_(blockpos1.m_142300_(direction)).m_60713_(Blocks.f_50141_)) {
                    ++j;
                }
                if (j > 1) break;
            }
            if (j != true) continue;
            glowstoneConsumer.accept(blockpos1, glowstone);
        }
        if (!set.isEmpty()) {
            ArrayList glowstonePositions = Lists.newArrayList((Iterable)set);
            List<BlockPos> positionsWithAir = glowstonePositions.stream().flatMap(pos -> Stream.of(Direction.values()).map(direction -> Feature.m_65810_((LevelSimulatedReader)worldgenlevel, (BlockPos)pos.m_142300_(direction)) ? pos : null)).filter(Objects::nonNull).toList();
            BlockPos nestPos = positionsWithAir.get(random.nextInt(positionsWithAir.size()));
            worldgenlevel.m_7731_(nestPos, ((BlockStateConfiguration)conf.m_159778_()).f_67547_, 2);
            worldgenlevel.m_141902_(nestPos, (BlockEntityType)ModTileEntityTypes.SOLITARY_NEST.get()).ifPresent(nestBlockEntity -> {
                ProductiveBees.LOGGER.debug("Spawned glowstone nest at " + nestPos + " " + ((BlockStateConfiguration)conf.m_159778_()).f_67547_);
                BlockState nestBlock = nestBlockEntity.m_58900_();
                Block patt5079$temp = nestBlock.m_60734_();
                if (patt5079$temp instanceof SolitaryNest) {
                    SolitaryNest solitaryNest = (SolitaryNest)patt5079$temp;
                    List<BeeSpawningRecipe> recipes = solitaryNest.getSpawningRecipes((Level)worldgenlevel.m_6018_(), (Biome)worldgenlevel.m_204166_(blockpos).m_203334_());
                    BeeSpawningRecipe spawningRecipe = recipes.get(random.nextInt(recipes.size()));
                    BeeIngredient beeIngredient = (BeeIngredient)spawningRecipe.output.get(random.nextInt(spawningRecipe.output.size())).get();
                    try {
                        CompoundTag bee = BeeHelper.getBeeAsCompoundTag(beeIngredient);
                        nestBlockEntity.addBee(bee, random.nextInt(599), 600, null, new TranslatableComponent("entity.productivebees." + beeIngredient.getBeeType().m_135815_()).getString());
                    }
                    catch (CommandSyntaxException e) {
                        ProductiveBees.LOGGER.warn("Failed to put bee into glowstone nest :(" + e.getMessage());
                    }
                }
            });
        }
        return true;
    }
}

